%CODWTCV  Writes Code details in TCV tree
% CODWTCV(SHOT,TREE,BRANCH,CODENAME,COMMENT) writes the
% code details in the BRANCH of TREE for SHOT.
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
function codwtcv(shot,tree,branch,codename,comment)
 
 [~,code] = meqver;

 %% Code
 meqmdsopen(shot,tree,branch)
 meqput('NAME'      ,codename   ,'t',{                         },'','Name of the code that produced the results'                 );
 meqput('COMMIT'    ,code.commit,'t',{{'meq','genlib','psitbx'}},'','Unique commit reference of the code and of its dependencies');
 meqput('VERSION'   ,code.tag   ,'t',{{'meq','genlib','psitbx'}},'','Unique version of the code (tag) and of its dependencies'   );
 meqput('REPOSITORY',code.url   ,'t',{{'meq','genlib','psitbx'}},'','URL of the code repository and of its dependencies'         );
 meqput('COMMENT'   ,comment    ,'t',{                         },'','Description of the run'                                     );
 
end
