function P = bfpgenD(Pu,nD)
% BFPGEND Consolidates bfgenD parameter structure from user input
%
%   P = BFPGEND(PU,ND)
%
% PU are the user-defined parameters for BFGEND (see BFGEND help for a
% description of the syntax) and ND is the number of allocated domains.
%
% See also: BFGEND
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

% Run checks
Pu = bfpck(@bfgenD,Pu,nD);

% Return if parameters are already consolidated
if isstruct(Pu)
  P = Pu;
  return;
end

nbf  = size(Pu,1);
bfct = Pu(:,1);
bfp  = Pu(:,2);
lD   = Pu(:,3);
if nbf, nD = size(lD{1},1);end

% Get number of basis functions
ngi = zeros(nbf,1);
for ibf = 1:nbf
  ngi(ibf) = numel(Pu{ibf,1}(0,Pu{ibf,2}));
end
ng  = sum(ngi);

% List of domains per set
iDbf = cell(nbf,1);
for ibf = 1:nbf
  iDbf{ibf} = find(lD{ibf}).';
end

% Mode 0 outputs
fPg = zeros(ng,1);
fTg = zeros(ng,1);
TDg = false(nD,ng);
ig = 0;
for ibf = 1:nbf
  if ngi(ibf) == 0; continue; end % no bf coefficients for this set
  ig = ig(end)+(1:ngi(ibf));
  [fPg(ig),fTg(ig)] = bfct{ibf}(0,bfp{ibf});
  TDg(logical(lD{ibf}),ig) = true;
end

% Assemble
P.nbf  = nbf;
P.bfct = bfct;
P.bfp  = bfp;
P.lD   = lD;
P.ngi  = ngi;
P.ng   = ng;
P.nD   = nD;
P.iDbf = iDbf;
P.fPg  = fPg;
P.fTg  = fTg;
P.TDg  = TDg;

end
