function P = bfpdoublet(Pu)
% BFPDOUBLET Consolidates bfdoublet parameter structure from user input
%
%   P = BFPGEND(PU)
%
% PU are the user-defined parameters for BFDOUBLET (see BFDOUBLET help for
% a description of the syntax).
%
% See also: BFDOUBLET
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

% Run checks
Pu = bfpck(@bfdoublet,Pu);

% Return if parameters are already consolidated
if isstruct(Pu)
  P = Pu;
  return;
end

% get info on third basis function set
bfct3 = Pu{3,1}; bfp3 = Pu{3,2};
[fPg3,~] = bfct3(0, bfp3);
% build useful index sets
ngl = numel(Pu{1,1}(0, Pu{1,2})) + numel(Pu{2,1}(0, Pu{2,2}));
ngm = numel(fPg3);
igm = ngl+(1:ngm);
  
% this function wraps bfgenD and adds the trivially continued part of the
% mantle basis functions externally
PbfgenD = bfpgenD({Pu{1,1}  , Pu{1,2}, [1;0;0]; ...
                   Pu{2,1}  , Pu{2,2}, [0;1;0]; ...
                   Pu{3,1}  , Pu{3,2}, [0;0;1]},3);

[fPg,fTg,TDg] = bfgenD(0,PbfgenD);
TDg(:,igm) = true; % mantle degrees of freedom extended to lobes

% Assemble
P.PbfgenD = PbfgenD;
P.igm = igm;
P.fPg = fPg;
P.fTg = fTg;
P.TDg = TDg;

end
