function bool = startsWith(str,pattern)
% STARTSWITH True if text starts with pattern
%
% This is a minimal implementation of the MATLAB built-in function
% for use in `meq` using Octave
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  
  if ~iscell(str), str = {str}; end
  if ~iscell(pattern), pattern = {pattern}; end

  bool = false(size(str));
  for ii = 1:numel(pattern)
    bool = bool | strncmp(str,pattern{ii},length(pattern{ii}));
  end
end
