function str = getReport(ME)
% GETREPORT Get error message for exception
%
% This is a minimal implementation of the MATLAB built-in function
% for use in `meq` using Octave
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

  % This is not the same as the MATLAB format
  if isempty(ME.stack)
    str = ME.message;
  else
    istack = ME.stack(1);
    str = sprintf('Error using %s (file: %s, line %d):\n%s',...
            istack.name,istack.file,istack.line,ME.message);
    if numel(ME.stack)>1
      str = [str,newline];
      for ii = 2:numel(ME.stack)
        istack = ME.stack(ii);
        str = [str,sprintf('\nError in %s (file: %s, line %d)',...
                     istack.name, istack.file, istack.line)];
      end
    end
  end

end
