function bool = contains(str,pattern)
% CONTAINS True if pattern is found in text
%
% This is a minimal implementation of the MATLAB built-in function
% for use in `meq` using Octave
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
  
  if ~iscell(str), str = {str}; end
  if ~iscell(pattern), pattern = {pattern}; end

  bool = false(size(str));
  for ii = 1:numel(pattern)
    if isempty(pattern{ii})
      % contains returns true if pattern is empty
      bool(:) = true;
      break
    end
    % Since str is a cell array, the outpur of strfind is a cell array too
    bool = bool | ~cellfun(@isempty,strfind(str,pattern{ii}));
  end
end
