function SCdisp(SC)
% Display shape control struct
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

%% Parse inputs
p = inputParser;
% Validation functions
checkSC = @(SC) isstruct(SC);
% Add inputs
addRequired(p,'SC',checkSC);
% Get parser results
parse(p,SC);
% Sanity check
assert(numel(SC.t)==1,'supported for 1 timeslice only, use meqxk() to slice')

%% Dispay control points infos
fprintf('\n           lsC, lsL, lsS, lsX1, lsX2, lsD, lsI,      R,      Z\n');
for ic = 1:SC.nc
  fprintf('%02d %s:   %d,   %d,   %d,    %d,    %d,   %d,   %d, %+2.3f, %+2.3f\n',...
    ic, SC.dimc{ic},SC.lcC(ic),SC.lcL(ic),SC.lcS(ic),SC.lcX1(ic),SC.lcX2(ic),...
    SC.lcD(ic),SC.lcI(ic),SC.rc(ic),SC.zc(ic));
end

end
