function Co = LX2Co(L,LX)
% Extract and pack Co from LX structure. 
% Co contains all fields listed in L.agconc
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.
Co = zeros(L.nC,numel(LX.t)); 
for iC=1:L.nC
  ii = L.agconc{iC,4};
  field = L.agconc{iC,3}; % field and index for this constraint
  if strcmp(field,'fbtlegacy'), continue; end % Skip constraints without LX field
  assert(isfield(LX,field), 'Request constraint %s not available in input LX structure', field);
  Co(iC,:) = LX.(field)(ii,:);
end
end