% Matlab EQuilibrium Toolbox
% Version 6.2.0 1-Jan-1970
%
% HELP
%   meqhelp     - Main symbol dictionary and various types of help per code
% 
% LIUQE Equilibrium reconstruction
%   liu         - LIUQE top level equilibrium reconstuction
%   liup        - LIUQE default algorithm configuration parameters
%   liug        - LIUQE geometry and electromagnetic parameters
%   liux        - LIUQE diagnostic measurements
%   liuc        - LIUQE ancillary data
%   liut        - LIUQE reconstruction
%   liuzf       - LIUQE calling scheme for vertical stabilisation functions
%   liudz       - LIUQE vertical stabilisation function based on shift fitting
%   liuz0       - LIUQE vertical stabilisation function based on ZA-Z0
%
%  RT LIUQE Simulink equilibrium reconstruction
%   liusimc     - LIUQE initialisation for LIUSIM model
%
% FBT Free Boundary Tokamak Equilibrium
%   fbt         - FBTE top level function
%   fbtp        - FBTE default configuration parameters
%   fbtg        - FBTE geometry and electromagnetic parameters
%   fbtc        - FBTE ancillary data
%   fbtx        - FBTE input data retrieval/handling
%   fbtt        - FBTE equilibrium calculation
%
% FGS Free Boundary Static Forward solver
%   fge         - FGS top level function
%   fgep        - FGS default configuration parameters
%   fgeg        - FGS geometry and electromagnetic parameters
%   fgec        - FGS ancillary data
%   fgsx        - FGS input data retrieval/handling
%   fget        - FGS equilibrium calculation
%
% FGE Free Boundary Evolutive Forward Solver
%   fge         - FGE top level function
%   fgep        - FGE default configuration parameters
%   fgeg        - FGE geometry and electromagnetic parameters
%   fgec        - FGE ancillary data
%   fgex        - FGE input data retrieval/handling
%   fget        - FGE equilibrium (time-stepping) calculation
%
% MEQ MatlabEQuilibrium Toolbox
%  MEX files for libmeq toolbox
%   asxymex      - Localise extrema and saddle points of a 2D-map
%   bavxmex      - Find points inside X-point polygon
%   bboxmex      - Domain bounding box
%   bslvmex      - Block solving algorithm
%   fbndmex      - Find LCFS
%   gszrmex      - Solve Poisson equation
%   iatamex      - LDL matrix inversion
%   ipm4mex      - Interior point method for aX>0 and no equality constraints 
%   ipmhmex      - Fit FE elements with Interior Point Method
%   fsgimex      - Flux surface geometrical integrals
%   nfdbmex      - Normal flux derivative on boundary
%   pdommex      - Find plasma domain
%   respmex      - Build internal response matrix
%   rtcimex      - Isoflux contouring
%   
%   fetr         - TRiangular Finite Elements
%   febi         - Bilinear finite elements
%   gszrc        - Ancillary data for GSZR Poisson solver
%   meq2psi      - Convert MEQ LY structure to PSITBXPSI object
%   meqc         - MEQ ancillary data
%   meqfbp       - Plasma contribution to boundary condition for Poisson solver
%   meqg         - MEQ geometry and electromagnetic parameters
%   meqint       - Equilibrium integrals
%   meqmesh      - Computational grid related quantities
%   meqpdom      - Plasma domain parameters
%   meqpost      - General equilibrium post-processing
%   meqxk        - Extracts samples from LX/LY structure
%   meqxconvert  - Convert meq equilibrium from one representation to another
%   meqreprocess - Reprocess meq equilibrium to compute post-processing and more
%
%  Base functions for p',TT'
%   bfhelp      - Calling scheme for base functions for p',TT'
%   bf3imex     - 3 base functions for p',TT' by tabular interpolation
%   bf3pmex     - 3 polynomial base functions for p',TT'
%   bfabmex     - Polynomial base functions for p',TT'
%   bfef        - Constant and polynomial base functions for p',TT'
%   bfprmex     - Tabular base function integrals for p',TT'
%   bffbt       - FBT base functions for p',TT'
%
% PLOTTING
%   meqplott     - Time slice plot
%   meqplotevo   - Time evolution
%   meqplotfancy - fancy plot
%   meqmovie     - Movie of time history
%
% SPECIFIC TOKAMAKS
%  TCV GENERIC
%   mds2meq     - Read TCV MDS nodes to meq structure
%   ts2LY       - From Simulink timeseries to LY object
% 
%  TCV LIUQE
%   liuqe       - TCV LIUQE equilibrium reconstuction
%   liuptcv     - TCV LIUQE configuration parameters
%   liugtcv     - TCV LIUQE geometry and electromagnetic parameters
%   liuxtcv     - TCV LIUQE diagnostic measurements
%   liuxrtc     - TCV LIUQE diagnostic measurements from RTC tree
%   meqgtcv     - TCV MEQ geometry and electromagnetic parameters
%
%  RESULTS tree
%   meqwtcv     - Writes MEQ data in TCV tree
%   liuwtcv     - Write LIUQE specific data in TCV tree
%   psiwtcv     - Write PSITBX specific data in TCV tree
%   liuanasrv   - Called by ANASRV to compute and write in RESULTS tree
%   liuqe_times - Determine time array for LIUQE anasrv call
%
%  TCV FBTE
%   fbte        - TCV FBTE equilibrium calculation
%   fbtptcv     - TCV FBT configuration parameters
%   fbtgtcv     - TCV FBT geometry and electromagnetic parameters
%   fbtwtcv     - Write FBT specific data in TCV tree
%
%  CREATE(ITER) LIUQE
%   liupcreate  - CREATE(ITER) LIUQE algorithm configuration parameters
%   liugcreate  - CREATE(ITER) LIUQE geometry
%   liuxcreate  - CREATE(ITER) LIUQE diagnostic measurements
%   createf     - CREATE(ITER) Locates equilibrium file
%
%  RFX LIUQE
%   liuprfx     - RFX LIUQE configuration parameters
%   liugrfx     - RFX LIUQE geometry and electromagnetic parameters
%   liuxrfx     - RFX LIUQE diagnostic measurements
%
% DEVELOPERS
%  Code generation
%   meqld       - Selects ld script for MEQ
%   mkcsf       - Makes C code for S-function blocks using Legacy Tool
%   mkldl       - Generates code for LDL inversion
%   mkmeqh      - Generates include file MEQ.H
%   liucomp     - function liucomp(L1,LY1,L2,LY2,labels)
%   liuxcomp    - LIUQE measurement signal comparison
%
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

