function LX = Co2LX(L,LX,Co)
% CO2LX Update LX with values from constraints vector Co 
% Co contains all fields listed in L.agconc
% This is the inverse process of LX2Co
%
% See also LX2CO
% [+MEQ MatlabEQuilibrium Toolbox+] Swiss Plasma Center EPFL Lausanne 2022. All rights reserved.

% Update LX
for iC = 1:L.nC
  field = L.agconc{iC,3};
  index = L.agconc{iC,4};
  if strcmp(field,'fbtlegacy'), continue; end % Skip constraints without LX field
  val = LX.(field);
  val(index) = Co(iC);
  LX.(field) = val;
end
end
