## Citation policy

You are welcome to generate scientific papers based on results obtained using the MEQ code. If the work was done independently, there is no need to add authors of the code as co-authors to the paper. 

However, following good scientific codes of conduct we kindly ask to cite the appropriate publications below depending on your use-case. These may be updated so please check for the latest version.

## List of papers

### Original paper on FBT (FORTRAN version)
[1] F. Hofmann, "FBT - a free-boundary tokamak equilibrium code for highly elongated and shaped plasmas," Comput. Phys. Commun., vol. 48, no. 2, pp. 207-221, 1988. [DOI link](https://dx.doi.org/10.1016/0010-4655(88)90041-0)


<details><summary>BibTeX</summary>

```
@article{Hofmann-CPC-1988-FBT,
author = {Hofmann, F},
doi = {10.1016/0010-4655(88)90041-0},
issn = {00104655},
journal = {Computer Physics Communications},
month = {feb},
number = {2},
pages = {207--221},
title = {{FBT - a free-boundary tokamak equilibrium code for highly elongated and shaped plasmas}},
volume = {48},
year = {1988}
}

```
</details>


### Original paper on LIUQE (FORTRAN version)
[2] F. Hofmann and G. Tonetti, "Tokamak equilibrium reconstruction using faraday rotation measurements," Nucl. Fusion, vol. 28, no. 10, p. 1871, 1988. [DOI link](https://dx.doi.org/10.1088/0029-5515/28/10/014)

<details><summary>BibTeX</summary>

```
@article{Hofmann-NF1988-LIUQE,
author = {Hofmann, F and Tonetti, G},
doi = {10.1088/0029-5515/28/10/014},
issn = {0029-5515},
journal = {Nuclear Fusion},
month = {oct},
number = {10},
pages = {1871--1878},
title = {{Tokamak equilibrium reconstruction using Faraday rotation measurements}},
volume = {28},
year = {1988}
}
```
</details>

### Paper on fast boundary identification methods used in MEQ
[3] F. Hofmann and G. Tonetti, "Fast identification of plasma boundary and X-points in elongated tokamaks," Nucl. Fusion, vol. 28, no. 3, pp. 519-522, Mar. 1988.  [DOI link](https://dx.doi.org/10.1088/0029-5515/28/3/015})

<details><summary>BibTeX</summary>

```
@article{Hofmann-NF1988-Boundary,
author = {Hofmann, F. and Tonetti, G.},
doi = {10.1088/0029-5515/28/3/015},
issn = {0029-5515},
journal = {Nuclear Fusion},
month = {mar},
number = {3},
pages = {519--522},
title = {{Fast identification of plasma boundary and X-points in elongated tokamaks}},
volume = {28},
year = {1988}
}
```
</details>


### LIUQE-Matlab and real-time implementation
[4] J.-M. Moret, B. P. Duval, H. B. Le, S. Coda, F. Felici, and H. Reimerdes, "Tokamak equilibrium reconstruction code LIUQE and its real time implementation", Fusion Eng. Des., vol. 91, no. 0, pp. 1-15, Feb. 2015. [DOI link](https://dx.doi.org/10.1016/j.fusengdes.2014.09.019)


<details><summary>BibTeX</summary>

```
@article{Moret-FusEngDes2015-LIUQE-MATLAB,
author = {Moret, J.-M. and Duval, B.P. and Le, H.B. and Coda, S and Felici, F and Reimerdes, H},
doi = {10.1016/j.fusengdes.2014.09.019},
issn = {09203796},
journal = {Fusion Engineering and Design},
keywords = {Equilibrium,MHD,Real-time,Reconstruction,Tokamak},
month = {feb},
pages = {1--15},
title = {{Tokamak equilibrium reconstruction code LIUQE and its real time implementation}},
volume = {91},
year = {2015}
}
```
</details>


### FGE and FGE free-boundary evolutive/static solvers
[5] F. Carpanese, _"Development of free-boundary equilibrium and transport solvers for simulation and real-time interpretation of tokamak experiments."_  EPFL PhD thesis n7914, 2021. [DOI link](https://doi.org/10.5075/epfl-thesis-7914)

<details><summary>BibTeX</summary>

```
@article{Carpanese-PHD2021,
      title = {Development of free-boundary equilibrium and transport  solvers for simulation and real-time interpretation of  tokamak experiments},
      author = {Carpanese, Francesco},
      publisher = {EPFL},
      address = {Lausanne},
      pages = {238},
      year = {2021},
      doi = {10.5075/epfl-thesis-7914}
}
```
</details>


### COCOS - tokamak coordinate convention system
[6] O. Sauter and S. Y. Medvedev, “Tokamak coordinate conventions:,” Comput. Phys. Commun., vol. 184, no. 2, pp. 293–302, Feb. [DOI link](https://doi.org/2013.10.1016/j.cpc.2012.09.010)


<details><summary>BibTeX</summary>

```
@article{Sauter-CPC2013-COCOS,
author = {Sauter, O and Medvedev, S.Yu.},
doi = {10.1016/j.cpc.2012.09.010},
issn = {00104655},
journal = {Computer Physics Communications},
keywords = {Standard},
month = {feb},
number = {2},
pages = {293--302},
title = {{Tokamak coordinate conventions:}},
volume = {184},
year = {2013}
}
```

## BibTeX

