#!/bin/bash
# testing script for Continuous Integration
# F. Felici federico.felici@epfl.ch

## test type
if [[ -z "$1" ]]
then
  echo 'usage:'
  echo ' Run matlab tests: '
  echo '     ./test_script.sh $matlabcmd $test_to_run'
  echo '     will call required matlab and run >>test_matlab($test_to_run)'
  echo '   $matlabcommand is the command used to launch the correct matlab version'
  echo '   works on SPC lac clusters for now'
  exit 1
fi

matlabbin=$1
testargument=$2

matlab_call="tests_matlab('$testargument')"
if [[ $OS = "Windows_NT" ]]
then
  full_args="-batch $matlab_call"
else
  matlabargs="-nodesktop -nosplash -noFigureWindows"
  full_args="$matlabargs -r $matlab_call"
fi
echo "$matlabbin" $full_args

exec "$matlabbin" $full_args ## execute
