#!/bin/bash

build_and_test() {
  make MATPATH=/c/Progra~1/MATLAB/R2022b LINK=$1 LOCAL=$2 TIMEOUT=$3 $4 -B
  BUILD=$?
  if [[ $BUILD -eq 0 ]]
  then
    ./test_script.sh /c/Progra~1/MATLAB/R2022b/bin/matlab all
    TEST=$?
  else
    TEST=-1;
  fi
  printf "[build_and_test] LINK=%-7s LOCAL=%-3s TIMEOUT=%-3s BUILD=%+04d TEST=%+04d\n" $1 $2 $3 $BUILD $TEST
}

# Static builds 
build_and_test static no  no  MDSPLUS=mdsplus
build_and_test static no  yes MDSPLUS=mdsplus

# Shared builds
build_and_test shared no  no
build_and_test shared no  yes
build_and_test shared yes yes
build_and_test shared yes no

# Shared builds
build_and_test dynamic no  no
build_and_test dynamic no  yes
build_and_test dynamic yes yes
build_and_test dynamic yes no

