function [pout] = mdstimeout(p)
% MDSTIMEOUT control timeouts for MDSip connections
%
%   mdscontimeout([conn,send,recv]) sets [Connection,send,receive] timeouts (seconds)
%
% returns old timeouts (seconds) if requested
%
% Basil P. DUVAL, 2020

if nargin < 1
  error('Specify timeout in seconds.')
else
  if(numel(p) < 3)
    error('Requires vector 3 long: [connection, send, receive] in seconds')
  end
  status= mdsipmex(12,p);
end
