function status = mdstcl(command)

% MDSTCL Tree Command Language from MDS
%    MDSTCL(COMMAND) sends COMMAND to TCL and returns the STATUS.

if nargin < 1, command = ''; end
stat = mdsvalue('Tcl($)',command);
if nargout
  status = stat;
elseif ~rem(stat,2)
  warning('Unsuccessful command')
  disp(command)
  disp(mdsdata('getmsg($1)',stat))
end
