function status = mdsput(node,x,cvt,varargin)

% MDSPUT puts data in MDS data base
%   MDSPUT(NODE,A,TYPE) writes A into NODE with TYPE conversion 'd'ouble,
%   'f'loat, 'q'uadword, 'l'ong, 's'hort, signed 'c'har, unsigned 'Q'uadword,
%   u'L'ong, u'S'hort, u'C'har, 't'ext or TDI e'x'pression and returns the
%   STATUS. MDSPUT(NODE,EXPR,'x',P1,...) writes the TDI expression EXPR using
%   Ps for $ placeholders. Usage of MDSCVT objects spares network bandwidth.
%   MDSPUT(NODE,MDSCVT(A,'f')) is equivalent to MDSPUT(NODE,A,'f').
%
%   'x' can be omitted
%

switch nargin
 case {0,1}
  error('Specify the node and the content.')
 case 2
  stat = mdsdata('TreePut($1,"$1",$2)',node,x);
 case 3
  switch cvt
   case 'x',  stat = mdsdata('TreePut($1,$2)',node,x);
   case 't',  stat = mdsdata('TreePut($1,"TEXT($1)",$2)',node,x);
   otherwise, 
    if ischar(cvt) && length(cvt)==1
      stat = mdsdata('TreePut($1,"$1",$2)',node,mdscvt(x,cvt));
    else
      stat = mdsdata('TreePut($1,"$1",$2,$3)',node,x,cvt);
    end
  end
 otherwise
  if ischar(cvt) && strcmp(cvt,'x')
    stat = mdsdata(['TreePut($1,$2' sprintf(',$%d',3:nargin-1) ')'],node,x,varargin{:});
  else
    stat = mdsdata(['TreePut($1,$2' sprintf(',$%d',3:nargin) ')'],node,x,cvt,varargin{:});
  end
end
if nargout
 status = stat;
elseif ~rem(stat,2)
 warning('Unsuccessful put in node "%s".\n%s',node,mdsdata('GetMsg($1)',stat))
end
