/*
Copyright (c) 2017, Massachusetts Institute of Technology All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.

Redistributions in binary form must reproduce the above copyright notice, this
list of conditions and the following disclaimer in the documentation and/or
other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <libroutines.h>

#include "../mdsshr/version.h"
#include "mdsip_connections.h"

////////////////////////////////////////////////////////////////////////////////
//  LoadIo  ////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////

extern IoRoutines tunnel_routines;
extern IoRoutines thread_routines;
extern IoRoutines *Io();

IoRoutines *LoadIo(char *protocol_in) {
//  if (protocol_in != 0) printf("trying protocol %s\n",protocol_in);
  char *protocol = strcpy((char *)malloc(strlen(protocol_in) + 1), protocol_in);
  IoRoutines *(*rtn)() = &Io;

  size_t i;
     for (i = 0; i < strlen(protocol); i++)
              protocol[i] = toupper(protocol[i]);
  if (strcmp(protocol, "TCP") == 0) {
      free(protocol);
      return Io();
  }
  free(protocol);
  return &tunnel_routines;
}
