function [shoto,status] = mdsopen(tree, shot)
% MDSOPEN open tree on remote MDSip server
%
%   mdsopen('tcv_shot',12345);
%   mdsopen(shot) % defaults to mdsopen('tcv_shot',shot);
%   [shoto,status] = mdsopen(tree,shot); % returns the status of the TreeOpen
%   operation in status and the effective shot number opened in shoto (if
%   the operation is unsuccessful then shoto will be empty)
%
% If no connection is available then a connection to the default
% server is open (see mdsdefaultserver).
%
% The tree argument can include a server specification using the syntax
% server::treename, e.g. mdsopen('tcvdata.epfl.ch::tcv_shot',0)
%
% If no shot is provided or if shot is a string, then only the
% initial connect step is performed.
%
% Warning: the ability to open a new connection through mdsopen will be
%          removed in a future release
%
% Basil P. DUVAL, Oct 1998

if(nargin < 1);tree='';shot='none';
elseif(nargin< 2 && ~ischar(tree));shot=tree;tree='tcv_shot';
elseif(nargin< 2 && ischar(tree));shot='none';
elseif(nargin >2 || ~ischar(tree) || ischar(shot));error('Incorrect arguments to mdsopen');
end
if isnumeric(shot), shot = double(shot);end

% open the shot

status = mdsipmex(1,tree,shot);

% return the open shot number if successful
if(rem(status,2) == 1 && nargout > 0 && ~strcmp(shot,'none'))
  shoto = mdsipmex(2,'$SHOT');
else
  if(nargout > 0);shoto=[];end
end
