function varargout = resamp(varargin)

% TDI/RESAMP Time resampling of TDI objects
%			[R1,...] = RESAMP(T1,...[,T][,MODE]) resamples the TDI objects T1,... on a
%			common time base. If Ts are matrices, the time must be along the first
%			dimension. The new time base can be explicitly given by T, a time vector or
%			a sampling period, and/or a three letter MODE (default 'fel') : ['f'astest
%			or 's'lowest sampling period, 'r'estricted or NaN padded 'e'xtended time
%			window, 'n'earest sample or 'l'inear or 'c'ubic or 's'pline interpolation].

% build command to evaluate to prevent copies
in  = '';
out = '';
narg = 0;
for k = 1:nargin
	switch class(varargin{k})
  case 'tdi'
	  in = [in ',varargin{' int2str(k) '}.data,varargin{' int2str(k) '}.dim{1}'];
		 out = [out ',varargin{' int2str(k) '}.data'];
			narg = narg + 1;
	 case 'double'
		 t = varargin{k};
			in = [in ',t'];
	 case 'char'
		 mode = varargin{k};
			in = [in ',mode'];
		otherwise, error('Invalid %dth argument',k),
	end
end
in(1)  = '';
out(1) = '';
cmd = ['[' out ',tr] = resamp(' in ');'];

eval(cmd)

for k = 1:narg
	varargout{k} = varargin{k};
	varargout{k}.dim{1} = tr;
end
