% Study of the superstable 3-cycle

global a;
r = roots([-1 2 -1 1]);
a = r(imag(r)==0);	% Compute 'a' for which there is a superstable 3-cycle 

x0 = 0.2;
N  = 100;

X  = compute_map(x0,N); % Computes map all the way to x_N

%% Cobweb plot (c)
cobweb(X); % A plot

%% Convergence (d)
plot_evolution(X); % Another plot

%%

convergence(X); % Convergence plot





