% Creates a convergence plot for the points of the cycle converging to x=0
% X = vector with successive values of x_n
function convergence(X)

N = ceil( numel(X)./3 ); % Round up of numel(X)/3 
oneInThreeX  = zeros(N,1); % Store sequence with any one element out of 3
for i=1:N
	oneInThreeX(i) = X(1+3*(i-1)); % Extract 1 element out of 3
end


figure; hold on; grid on; box on;
plot(linspace(1,N,N),abs(oneInThreeX-1),'-k.'); % Convergence plot
set(gca,'FontSize',14,'YScale','log');
xlabel('Iterations'); ylabel('Distance to x=1'); 

end