% Creates the cobweb plot
% X = vector with successive values of x_n
function cobweb(X)

xx = linspace(-1,1,200);

figure; grid on; box on; hold on;
xlim([xx(1), xx(end)]); ylim([min([diffEq(xx) , xx]),max([diffEq(xx) , xx])]);
xlabel('x'); ylabel('f(x)'); 
set(gca,'FontSize',14);

plot(xx,xx,'-k','LineWidth',0.1); % Plot of y=x
plot(xx,diffEq(xx),'-k','LineWidth',0.1); % Plot of y=f(x)


N=numel(X);
for n = 2:N
	title({['Cobweb until n = ', num2str(n-1)]}); % Update value of 'n' in title
    
    plot([X(n-1) X(n-1) X(n)],[X(n-1) X(n) X(n)],'-r','LineWidth',0.001); % Plot vertical and horizontal line

    pause(2./n); % Use pause to animate
end

end
