% Exercise on bifurcation diagrams

%% (a) Bifurcation diagram

bifurcation_diagram(); % Change a in this script

%% (b) Plot of the f_a^n(1/2)
global a;
Na = 50;
y = ones(Na,1)*1./2; % Vector full of 1/2
a = linspace(3.4,4,Na)'; % Global variable becomes a vector with desired values of a

%figure; 
grid on; box on; hold on;
xlim([a(1),a(end)]); ylim([0,1]);
xlabel('a'); ylabel('x'); 
set(gca,'FontSize',14);

for n=1:5
	y=diffEq(y); % Compute the next iteration f_a^n(1/2)
	plot(a,y,'LineWidth',2);
end
legend({'$f_a(1/2)$','$f_a^2(1/2)$','$f_a^3(1/2)$','$f_a^4(1/2)$','$f_a^5(1/2)$'},'Interpreter','latex')






