% Creates the bifurcation diagram
function bifurcation_diagram()
global a;
Na=600;
%a_vec=linspace(0,4,Na);
a_vec=linspace(3.4,4,Na);
% a_vec=linspace(3.827,3.865,Na);
%a_vec=linspace(3.846,3.857,Na);

Niter = 1000; % Number of iterations (go up to x_{Niter})
Nplot = 400; % Number of points to plot (plot only last Nplot points)

figure; hold on; box on; grid on;
xlim([a_vec(1),a_vec(end)]); ylim([0,1]);
set(gca,'FontSize',14);
xlabel('a'); ylabel('x');

x0=0.5; % Initial conditions for the first simulation
for	na=1:Na
	a=a_vec(na); % Passing the value to a, the global variable that diffEq uses

	x = compute_map(x0,Niter);

    plot(ones(Nplot,1)*a,x(end-Nplot+1:end),'.k','MarkerSize',0.001);
end

end






