% Plots the trajectory and the Poincaré map of the system.
function poincare()

global a b c; % Differential equation parameters
a=1./4; b=1; 

% Initial conditions
% X0 = [-2.57718 0 0.184]'; c=3; % 1-cycle
% X0 = [-4.25835 0 0.1222]'; c=4; % 2-cycle
% X0 = [-3.87175 0 0.1169]'; c=4.75; % 4-cycle
% X0 = [-3.824 0 0.117]'; c=4.83; % 8-cycle
X0 = [-4 0 0.115]'; c=4.9; % Chaos 2 strips

dt=0.003; iter=200000; % Integration parameters
[XEuler,XRK4,Xode45] = integration(X0,dt,iter);



figure; % Poincare Map plot
hold on; grid on; box on;
for i=1:iter % Loop on all the trajectory points
	if XRK4(i+1,1)<0 && XRK4(i,1)>0 % When x1 goes from positive to negative
		plot(XRK4(i+1,2),XRK4(i+1,3),'.k'); % Plot the intersection of trajectory with the x2, x3 plane
	end
end
title(sprintf('Poincare map a=%3.3g, b=%3.3g, c=%3.3g',a,b,c));
set(gca,'FontSize',14); xlabel('x_2'); ylabel('x_3');


figure;
plotTrajectory(XEuler, XRK4, Xode45); % To compare

end
