% Exercise on the Rossler Attractor

% Parameters 
global a b c; % Global so that other functions (like diffEq ) can use them



%% Plot the trajectory converging to the fixed point x_-^* (a)
a=1./4; b=1.; c = 1.5;
X0=[1 0 0]'; dt=0.01; iter=10000;
[XEuler, XRK4, Xode45] = integration(X0,dt,iter);
figure; plotTrajectory(XEuler, XRK4, Xode45);


%% Analyse the order of convergence
a=1./4; b=1.; c = 1.5;
X0=[1 0 0]';
dt=logspace(-5,0,6);
iter = floor(2./dt);
compare_dt(X0,dt,iter)

%% Check linearization (f)-(g)
check_linearisation();

%% Animated plot of the eigenvalues for a=1/4, b=1 (h)
a=1./4; b=1.;
eigenvalue_plot()


%% Poincaré (l)
% See the script to change the parameter c
poincare();


