% Returns the two fixed points of the Rossler system (for a\neq0 and c^2>4ab)
% xplus and xminus are 3*1 vectors
function [xplus xminus] = fixedpoints()
global a b c;
sqroot = sqrt(c^2-4*a*b);
sol1 = (c+sqroot)/2;
sol2 = (c-sqroot)/2;
xplus = [ sol1; -sol1/a; sol1/a ];
xminus = [ sol2; -sol2/a; sol2/a ];
end 




