% Plots of the eigenvalues of the fixed points as c increases.
function eigenvalue_plot()

global a b c;
clim=sqrt(4*abs(a*b));
n=100; % Iterations on c
vec_c=linspace(clim,3*clim,n); % Values that c will take


% To store the 3 eigenvalues of the fixed points x^*_+ and x^*_-, at all n different values that c takes
eigval_plus = zeros(3,n);
eigval_minus = zeros(3,n);
for i=1:n % Loop on values of c
	c=vec_c(i); % The value of vec_c(i) is passed to fixedpoints() through the global variable c
	
	[xplus,xminus] = fixedpoints();	% Find the fixed points

	% Numerically find the eigenvalues, roots of the characteristic polynomial
	eigval_plus(:,i) = roots([-1 , xplus(1)-c+a , a*c-a*xplus(1)-1-xplus(3) , xplus(1)-c+a*xplus(3) ]); % For x^*_plus
	eigval_minus(:,i)= roots([-1 , xminus(1)-c+a , a*c-a*xminus(1)-1-xminus(3) , xminus(1)-c+a*xminus(3) ]); % For x^*_minus
end

% Sorts eigval_plus(:,i) by imaginary part so that eigval_plus(1,:) corresponds to an eigenvalue continuously moving as c is varied.
for	i=1:n
	eigval_plus(:,i)  = sort_imag( eigval_plus(:,i) );
	eigval_minus(:,i) = sort_imag( eigval_minus(:,i) );
end




%% BONUS Animated figure of eigenvalues moving in complex plane as c increases
% warning('off','all')
% figure;
% hold on; grid on; box on;
% xlabel('Real part'); ylabel('Imaginary part'); set(gca,'FontSize',14);
% xlim([-0.6 , 0.4]); ylim([-2.5 , 2.5]);
% 
% for	i=1:n % Loop through different values of c, to plot evolving eigenvalues
% 	cla; % Clear the figure
%     title(sprintf('a=%3.3g, b=%3.3g, c=%3.3g',a,b,vec_c(i))); % Update value of c in title
% 	
% 	% Plot the points moving
% 	plot(real(eigval_plus(:,i)),imag(eigval_plus(:,i)),'k+');
% 	plot(real(eigval_minus(:,i)),imag(eigval_minus(:,i)),'rx');
%     
%     if i==1 
% %        legend({'Eigenvalues for $\vec{x}_+^*$','Eigenvalues for $\vec{x}_-^*$'},...
% %            'Interpreter','latex','AutoUpdate','off');	
%         legend({'Eigenvalues for $\vec{x}_+^*$','Eigenvalues for $\vec{x}_-^*$'},...
%             'Interpreter','latex');	
%     end % Put legend only once to go faster
% 
% 	% Plots the trajectory curve
%     for j=1:3 % Loop on the 3 eigenvalues
% 		plot(real(eigval_plus(j,1:i)),imag(eigval_plus(j,1:i)),'k:');
% 		plot(real(eigval_minus(j,1:i)),imag(eigval_minus(j,1:i)),'r--');
%     end
% 	pause(5/n);
% end
% hold off;
% warning('on','all')



%% Figures with real and imaginary part as a function of c
figure; % For fixed point x_+^*
for i=1:3
	subplot(1,3,i); hold on; grid on; box on; 
    title(['$\vec{x}_+^*$ eigenvalue ' num2str(i)],'Interpreter','latex')
	plot(vec_c,real(eigval_plus(i,:)),'-k'); plot(vec_c,imag(eigval_plus(i,:)),'--r');
	ylim([-3 , 3])
	xlabel('c'); set(gca,'FontSize',14);
	legend({'$\Re$ part','$\Im$ part'},'Interpreter','latex');
end
figure; % For fixed point x_-^*
title('xplus')
for i=1:3
	subplot(1,3,i); hold on; grid on; box on; 
    title(['$\vec{x}_-^*$ eigenvalue ' num2str(i)],'Interpreter','latex')
	plot(vec_c,real(eigval_minus(i,:)),'-k'); plot(vec_c,imag(eigval_minus(i,:)),'--r');
	ylim([-2 , 2])
	xlabel('c'); set(gca,'FontSize',14);
	legend({'$\Re$ part','$\Im$ part'},'Interpreter','latex');
end



hold off;
end



