% Checks the predictions made by using linearisation and gets more information by launching simulations near the fixed point.
function check_linearisation()

global a b c;
a=1./4; b=1.; c = 1;

[xplus xminus] = fixedpoints();
dt=0.01; iter=10000;



% Simulation in eigenspace of eigenvalue 0
eigvec0= [0.25 -1. 1.]'; 
X0_1 = xplus-eigvec0*0.1; % Initial condition on one side
X0_2 = xplus+eigvec0*0.1; % Initial condition on other side

[XEuler_1, XRK4_1, Xode45_1] = integration(X0_1,dt,iter); % Simulation on one side
[XEuler_2, XRK4_2, Xode45_2] = integration(X0_2,dt,iter); % Simulation on other side

figure; hold on;
plot3(xplus(1),xplus(2),xplus(3),'xg'); % Plot the fixed point

plot3(XRK4_1(1,1),XRK4_1(1,2),XRK4_1(1,3),'+k'); % Plot the initial conditions
plot3(XRK4_2(1,1),XRK4_2(1,2),XRK4_2(1,3),'+k');

% Plot simulation on one side
%plot3(XEuler_1(:,1),XEuler_1(:,2),XEuler_1(:,3),'r-'); % Euler
%plot3(XRK4_1(:,1),XRK4_1(:,2),XRK4_1(:,3),'k-'); 		% RK4
plot3(Xode45_1(:,1),Xode45_1(:,2),Xode45_1(:,3),'b-'); % ode45

% Plot simulation on other side
%plot3(XEuler_2(:,1),XEuler_2(:,2),XEuler_2(:,3),'r-'); % Euler
%plot3(XRK4_2(:,1),XRK4_2(:,2),XRK4_2(:,3),'k-'); 		% RK4
plot3(Xode45_2(:,1),Xode45_2(:,2),Xode45_2(:,3),'b-'); % ode45

hold off; grid on; box on; % Making the figure nice
xlabel('x'); ylabel('y'); zlabel('z');
set(gca,'FontSize',14);
legend('Fixed point','Initial conditions');



% Simulation in spiral plane
eigvecplus = [3./16 29./64 1]'; % Real part of eigenvector
eigvecminus = [sqrt(183)./16 -sqrt(183)./64 0]'; % Imaginary part of eigenvector

X0 = xplus+eigvecplus*0.1; % Initial condition in spiral plane
[XEuler, XRK4, Xode45] = integration(X0,dt,iter);

new_basis = zeros(3,3); % New orthonormal basis centered at the fixed point with first two vectors in spiral plane
new_basis(:,1:2) = orth([eigvecplus eigvecminus]); % The columun vectors are an orthonormal basis of the spiral plane
normal = cross(eigvecplus,eigvecminus); 
new_basis(:,3) = normal/norm(normal); % Normalised vector in normal direction of the spiral plane

XRK4_new_basis = zeros(iter+1,3); % Coordinates of trajectory projected in the new basis
for i=1:iter+1 % Loop on all points of the trajectory XRK4
	for d=1:3 % Loop on the 3 vectors of new_basis
		XRK4_new_basis(i,d) = (XRK4(i,:) - xplus')*new_basis(:,d); % Scalar product between the new basis (centered at the fixed point) and trajectory points
	end
end

figure;
plot(XRK4_new_basis(:,1),XRK4_new_basis(:,2),'k-');
title('Projection in spiral plane');
grid on; box on; axis equal;
set(gca,'FontSize',14);

figure;
plot( linspace(0,dt*iter,iter+1),XRK4_new_basis(:,3),'k-'); 
title('Projection in normal direction');
grid on; box on;
set(gca,'FontSize',14); xlabel('time t')



end




