% Creates the phase portrait to visualise solution behaviours of differential equations

% Setting up the grids
% xinf = [-pi/2 -pi];
% xsup = [3*pi/2 pi];
xinf=[-pi -pi-1];
xsup=[pi pi+1];
n = 21;
x1 = linspace(xinf(1),xsup(1),n);
x2 = linspace(xinf(2),xsup(2),n);
[X1,X2] = meshgrid(x1,x2);


% Computing the vector field of diffEq
dX1 = zeros(size(X1));
dX2 = zeros(size(X1));
t0=0;
for i = 1:numel(X1)	% Loop on all elements of 2D matrix
    dX = diffEq(t0,[X1(i); X2(i)]);
    dX1(i) = dX(1);
    dX2(i) = dX(2);
end


% Normalisation (if desired)
norm_dX1 = dX1./sqrt(dX1.^2+dX2.^2);
norm_dX2 = dX2./sqrt(dX1.^2+dX2.^2);


% Quiver plot
figure;
quiver(X1,X2,norm_dX1,norm_dX2,0.7,'k');
% quiver(X1,X2,dX1,dX2,1.5,'k');
title('$\dot{\vec{x}}=(\cos x_1+\sin x_2,\cos x_1)$','Interpreter','latex');
grid on;
xlabel('x_1');
ylabel('x_2');
axis equal; %tight;
xlim([xinf(1),xsup(1)]); ylim([xinf(2),xsup(2)]);
set(gca,'FontSize',14);

%%
hold on
plot([-pi/2 -pi/2 pi/2 pi/2], [0 0 pi pi],'.','MarkerSize',10,'color','blue')

%% Stream plot
hold on; % To plot multiple trajectories
tf=10; % Final time
gridsize = 15; % Here the grid of initial conditions can be of different density than the one for quiver
[X1ini,X2ini] = meshgrid(linspace(xinf(1),xsup(1),gridsize),linspace(xinf(2),xsup(2),gridsize)); % Grid of initial conditions
for i=1:numel(X1ini) % Loop on the 2D matrix of initial conditions
    [~,Xsol] = ode45(@diffEq,[t0,tf],[X1ini(i),X2ini(i)]); % Integration
    if mod(i,2)==0  % For good looks, can alternate colors
    	color='r';
    else
    	color='k';
    end
    plot(Xsol(:,1),Xsol(:,2),color) % Trajectory
%     plot(Xsol(1,1),Xsol(1,2),[color 'o'],'MarkerSize',5) % Starting point
    %plot(Xsol(end,1),Xsol(end,2),[color '.']) % Ending point
end
xlim([xinf(1),xsup(1)]); ylim([xinf(2),xsup(2)]);
hold off;





