% Program to compute and visualise the Picard iteration method to solve differential equations

% Parameters
t0 = 1.; % Initial time
tf = 51.; % Final time
temporal_iter = 5000; % Number of temporal iterations
dt = (tf-t0)/temporal_iter; % Time step
t = (t0:dt:tf)'; % Linearly spaced time vector
X0 = 1/2.; % Initial condition

%% First iteration (a)
picard_iter = 1; % Number of Picard iterations

% Integration
ode_tol = 1e-5; % Relative tolerance of the ode45 solution
[X,Xode45] = integration(picard_iter, temporal_iter, dt, t, X0,ode_tol);

% Plot 
figure
minY = 0; maxY = 30; % To keep the y scale constant
plot(t,Xode45,'r--');
hold on
plot(t,X(:,2),'k')
hold off
legend('x_{\rm sol}',sprintf('x_1, \\Delta t=%3.3f',dt));
ylim([minY,maxY]); 
xlim([t(1),t(end)]); 
%% Convergence to ode45 solution (b)
picard_iter = 50; % Number of Picard iterations

% Integration
ode_tol = 1e-5; % Relative tolerance of the ode45 solution
[X,Xode45] = integration(picard_iter, temporal_iter, dt, t, X0,ode_tol);

% Animated Plot
figure
for n=2:picard_iter+1
    fixedPlot( X(:,n), t, n-1, Xode45) % Plot of the n^th iteration (with fixed boundaries)
    pause(1./n)
end

%% Check convergence for the default case (c)
picard_iter = 20;
tf=11.;
temporal_iter = 100;
ode_tol=1e-3;

compare_dt(picard_iter,temporal_iter,t0,tf,X0,ode_tol);

%% Different tolerances and dt (d)

picard_iter = 20;
tf=11.;
temporal_iter = round(logspace(2,5,4))';
ode_tol = [1e-7; 1e-5 ; 1e-3];
% temporal_iter = round(logspace(2,7,4))';
% ode_tol = [1e-11 ; 1e-5 ; 1e-3];

for j=1:size(ode_tol,1)
	compare_dt(picard_iter,temporal_iter,t0,tf,X0,ode_tol(j));
	drawnow;
end




