% To plot the intermediate solution Xn with final solution Xode45
% Xn : column vector, values X(t) of the n^th Picard iteration from t0 to tf
% t : column vector, discretised values of t 
% n : scalar, where Xn is the n^th Picard iteration
% Xode45 : column vector, values X(t) of the ode solution from t0 to tf
function fixedPlot(Xn,t,n,Xode45)

minY = 0; maxY = 30; % To keep the y scale constant

plot(t,Xn,'k'); % Plot n^th Picard iteration
hold on; % To keep the previous plot
plot(t,Xode45,'r--'); % Plot the solution
hold off;
legend(sprintf('x_{%d}, \\Delta t=%3.3f',n,t(2)-t(1)), 'x_{\rm sol}'); 
set(gca,'FontSize',14); % Set font size to 14
xlabel('time t'); ylabel('x(t)');
ylim([minY,maxY]); 
xlim([t(1),t(end)]); 
end


