% Plot the distance between Xode45 with precision ode_tol and and the Picard iterations from 0 to picard_iter.
% Puts multiple dt on the same graph
% picard_iter : scalar, highest iteration computed
% temporal_iter : vector (size_dt,1) smallest to biggest, corresponding to the different dt to be plotted on the same graph
% t0,tf : scalars, initial and final times
% X0 : scalar, initial condition
% ode_tol : scalar, relative tolerance
function compare_dt(picard_iter,temporal_iter,t0,tf,X0,ode_tol)

dt= (tf-t0)./temporal_iter; % vector : Time steps corresponding to the the temporal iterations desired for each simulations
size_dt = size(dt,1);
dist = zeros(picard_iter+1,1); % Distances between Xn and Xode45


figure;
labels = {}; hold on; % Labels for the legend
for i=1:size_dt % Loop to make plots with the different dt

	[X,Xode45] = integration( picard_iter, temporal_iter(i), dt(i), linspace(t0,tf,temporal_iter(i)+1), X0, ode_tol); % Integration

	for n=1:picard_iter+1 
	    dist(n) = distance( X(:,n) ,Xode45 ,dt(i)); % Distance Xn to Xode45 
	end

	plot( (0:1:picard_iter), dist, '.-');
	labels= [labels sprintf('\\Delta t=%0.4g', dt(i))];
end

hold off; % Figure parameters
set(0,'DefaultTextInterpreter','tex')
title(sprintf('ode Tolerance=$10^{%i}$', log10(ode_tol)),'Interpreter','latex');
grid on;
set(gca,'FontSize',14,'YScale','log');
xlabel('Picard iteration n'); 
ylabel('||x_n-x_{\rm sol}||_2','Interpreter','latex');
ylim([1e-6,1e2]);
legend(labels)

end



