% Program to compute and visualise the Picard iteration method to solve differential equations

% Parameters
picard_iter = 50; % Number of Picard iterations
t0 = 1.; % Initial time
tf = 50.; % Final time
temporal_iter = 5000; % Number of temporal iterations
dt = (tf-t0)/temporal_iter; % Time step
t = (t0:dt:tf)'; % Linearly spaced time vector
X0 = [1/2. ; 1 ]; % Initial condition (COLUMMN vector!)


% Integration
ode_tol = 1e-5; % Relative tolerance of the ode45 solution
[X,Xode45] = integration_vec(picard_iter, temporal_iter, dt, t, X0,ode_tol);


% Animated Plot
screensz = get(groot,'ScreenSize');
figure('Position',[.1*screensz(3) .25*screensz(4) .8*screensz(3) .5*screensz(4)]); % Sets the position and size of figure window (here to make it big)
for n=2:picard_iter+1
    fixedPlot_vec( X(:,:,n), t, n-1, Xode45) % Plot of the n^th iteration (with fixed boundaries)
    pause(1./n)
end








