% Uses Picard iteration method to solve a differential equation
% X : matrix size (temporal_iter+1,dim,picard_iter+1), values from X(t0) to X(tf) for all picard iterations
% Xode45 : matrix size (temporal_iter+1,dim), values from X(t0) to X(tf) of the ode45 solution
% picard_iter : scalar, highest iteration computed
% temporal_iter : scalar, # of temporal iterations from t0 to tf for integration
% t : column vector size (temporal_iter+1), values from t0 to tf
% X0 : column vector, initial condition
% ode_tol : scalar (or null matrix []), ode relative error tolerance
function [X,Xode45] = integration_vec(picard_iter,temporal_iter,dt,t,X0,ode_tol)

options = odeset('RelTol',ode_tol); % Set relative tolerance
[t,Xode45] = ode45(@diffEq_vec,t,X0,options); % Numerical solution


dim = size(X0,1); % Dimension
X = zeros(temporal_iter+1,dim,picard_iter+1); % Matrix with values from X(t0) to X(tf) for all dimensions, for all picard iterations
for i=1:dim % Initializing
    X(:,i,:) = X0(i);
end

for n=1:picard_iter % Loop of Picard iterations
    integ = zeros(dim,1);  % The integral over [t0 , t0+(i-1)*dt] of X_{n-1}

    for i=2:temporal_iter+1 % Loop over all times from t0 to tf
        integ = integ + dt*( diffEq_vec(t(i-1),X(i-1,:,n))+diffEq_vec(t(i),X(i,:,n)) )/2.; % Add the integral over [t0+(i-1)*dt , t0+i*dt] to the integral over [t0 , t0+(i-1)*dt] with trapezium approximation
        X(i,:,n+1) = X0 + integ;
    end
end 

end 

