% To plot the intermediate solution Xn with final solution Xode45
% Xn : matrix size (temporal_iter+1,dim), values X(t) of the n^th Picard iteration from t0 to tf
% t : column vector, discretised values of t 
% n : scalar, where Xn is the n^th Picard iteration
% Xode45 : matrix size (temporal_iter+1,dim), values X(t) of the ode solution from t0 to tf
function fixedPlot_vec(Xn,t,n,Xode45)

minY = [-3,-1.5]; maxY = [3,1.5]; % To keep the y scales constant

dim = size(Xn,2);
for d=1:dim
    subplot(1,dim,d) % Each vector component has its subplot
	plot(t,Xn(:,d),'k'); % Plot n^th Picard iteration
	hold on; % To keep the previous plot
	plot(t,Xode45(:,d),'r--'); % Plot the solution
	hold off;
	set(gca,'FontSize',14); % Set font size to 14
	xlabel('time t'); 
    ylabel(sprintf('$\\vec{x}_{%d}(t)\\cdot \\vec{e}_{%d}$',n,d),'Interpreter','latex');
	ylim([minY(d),maxY(d)]); 
	xlim([t(1),t(end)]); 
end


