(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     98130,       1672]
NotebookOptionsPosition[     97629,       1650]
NotebookOutlinePosition[     97967,       1665]
CellTagsIndexPosition[     97924,       1662]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{"x", " ", 
   RowBox[{"y", "/", 
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], ")"}]}]}]}]], "Input",
 CellChangeTimes->{{3.7368318513189383`*^9, 3.736831871792651*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"l", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{"Sqrt", "[", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "y"}], "]"}], ")"}], "^", "2"}], "+", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "1"}], "]"}], "[", "f", "]"}], "[", 
       RowBox[{"x", ",", "y"}], "]"}], ")"}], "^", "2"}]}], "]"}]}]], "Input",\

 CellChangeTimes->{{3.7368318858736563`*^9, 3.736831933106606*^9}, {
  3.7368320355393467`*^9, 3.7368320948154182`*^9}, {3.736832389112694*^9, 
  3.736832443890383*^9}, {3.736832521192914*^9, 3.736832521520732*^9}, {
  3.7368325831587543`*^9, 3.736832647433525*^9}, {3.73683347742736*^9, 
  3.736833479254257*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"l", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", 
      RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", 
      RowBox[{"-", "4"}], ",", "4"}], "}"}]}], "]"}], " ", 
  RowBox[{"(*", 
   RowBox[{"We", " ", "can", " ", "see", " ", "the", " ", "peaks"}], 
   "*)"}]}]], "Input",
 CellChangeTimes->{{3.736831953684245*^9, 3.7368319559257193`*^9}, 
   3.736832650345302*^9, 3.7368334871519337`*^9, {3.736851189808537*^9, 
   3.736851193507371*^9}, {3.7368512485373497`*^9, 3.736851252384529*^9}, {
   3.736851804811984*^9, 3.736851818421032*^9}}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1nXd8V0XWxkNoIRRXxbJSFgEVxRUUxe5cAZWqoO66K6AISEdRYRFFRQER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   "], {{
     {RGBColor[0.880722, 0.611041, 0.142051], EdgeForm[None], Specularity[
       GrayLevel[1], 3], 
      StyleBox[GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNm3f8l9P7x9/3fZ/73FZFGqIiK1pKVJqiJNEwUzIKZaSvrLLX15YV2ckq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          "]], Polygon3DBox[CompressedData["
1:eJwtm3kcVsMXxu+9c+99KRElpaJdQiWyFCrRohKlbAnZd1K2SBuVNhVFSFnT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          "]], Polygon3DBox[CompressedData["
1:eJwt13nAjlUax/Hn3R4RKiRr9gqvNWtCWctapOxakJ2alEqmMvaQmUGN0IiK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          "]], 
         Polygon3DBox[{{1334, 758, 895, 1663, 1193, 1194}, {1187, 1186, 1659, 
          885, 886, 1660}, {1616, 788, 619, 618, 920, 1434}, {1394, 870, 546, 
          547, 871, 1395}}]}],
       Lighting->{{"Ambient", 
          RGBColor[0.30100577, 0.22414668499999998`, 0.090484535]}, {
         "Directional", 
          RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
          ImageScaled[{0, 2, 2}]}, {"Directional", 
          RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
          ImageScaled[{2, 2, 2}]}, {"Directional", 
          RGBColor[0.2642166, 0.18331229999999998`, 0.04261530000000001], 
          ImageScaled[{2, 0, 2}]}}]}, {}, {}, {}, {}}, {
     {GrayLevel[0], Line3DBox[CompressedData["
1:eJwl0stLVGEYB+Bvxrt5+wsUl5LTXzCzcasLaamI5kKdSNtlIi3DCNeKt7zr
Ohl34kaRlmHltZxmGeElKiQk9Plw8TvP+x4O3/tyzmnsff54KBFCeC0Dilj3
uPxmS3EIdWxnA7v5iEPM8BXbOM5OznJOnqpzHOE23/ADJ7nPNRa4ySvucq4k
hCZzX8gnfR/TMp0M4bN+hl/iDB7E53nIdzziPI+5wEU5US/xlMv8yhV+4yrP
uMY81/k9nlUUwkMzh6Wg72dGHthtX//frju8YI55rvIjJ7jHMW7xJTf4XrLq
KXbwLVs5yjSfMcUu1nPQrL/MmlvLJ0xJkR1r9AlW89a9qrhT3I83rOQ/VvCa
5fwTv6WUqX+xlJc0JpzT2PAzns8fTMZ3qWlO3P8Pd9jrSl8=
       "]]}, 
     {GrayLevel[0.2], 
      Line3DBox[{1090, 1387, 680, 1089, 1682, 1292, 1091, 1683, 1293, 1092, 
       1684, 1294, 1093, 1685, 1295, 1094, 1686, 1296, 1095, 1687, 1579, 1756,
        1096, 1688, 1297, 1097, 1689, 1298, 1098, 1690, 1299, 1099, 1691, 
       1300, 1100, 1692, 1301, 1101, 1693, 1302, 1102, 1835, 1388, 1303, 
       1389}], Line3DBox[{1104, 1580, 1757, 1103, 695, 1105, 1694, 1304, 1106,
        1695, 1305, 1107, 1696, 1306, 1108, 1697, 1307, 1109, 1698, 1581, 
       1758, 1110, 1582, 1759, 1111, 1699, 1308, 1112, 1700, 1309, 1113, 1701,
        1310, 1114, 1702, 1311, 1115, 1703, 1312, 1116, 1704, 1313, 1117}], 
      Line3DBox[{1119, 1583, 1760, 1118, 1584, 1761, 1120, 711, 1121, 1675, 
       1705, 1507, 1314, 1122, 1883, 1555, 1556, 1315, 1123, 1706, 1316, 1124,
        1707, 1585, 1762, 1125, 1586, 1763, 1126, 1587, 1764, 1127, 717, 1128,
        1676, 1708, 1514, 1317, 1129, 1886, 1569, 1570, 1318, 1130, 1709, 
       1319, 1131, 1710, 1320, 1132}], 
      Line3DBox[{1134, 1588, 1765, 1133, 1589, 1766, 1135, 1509, 1510, 1870, 
       1136, 1511, 844, 1508, 1374, 1538, 1137, 1558, 1863, 1487, 1557, 1488, 
       1138, 1884, 1559, 1560, 1139, 1711, 1590, 1767, 1140, 1591, 1768, 1141,
        1592, 1769, 1142, 1390, 1391, 1836, 1143, 1654, 1872, 1515, 1375, 
       1516, 1144, 1572, 1871, 1512, 1571, 1513, 1145, 1712, 1321, 1146, 1713,
        1322, 1147}], 
      Line3DBox[{1149, 1593, 1770, 1148, 1594, 1771, 1150, 1595, 1772, 1151, 
       1671, 1864, 1490, 1489, 1539, 1152, 1518, 848, 1517, 1376, 1540, 1153, 
       1680, 1865, 1491, 1561, 1492, 1154, 1837, 1394, 1395, 1853, 1155, 1396,
        1397, 1838, 1156, 1398, 1399, 1839, 1157, 1377, 1392, 1773, 1655, 
       1158, 1656, 1852, 1439, 1393, 1159, 1596, 1774, 1160, 1714, 1323, 1161,
        1715, 1324, 1162}], 
      Line3DBox[{1164, 1597, 1775, 1163, 1598, 1776, 1165, 1599, 1777, 1166, 
       1600, 1778, 1167, 1672, 1866, 1493, 1542, 1541, 1168, 1020, 1520, 1519,
        1378, 1169, 1879, 1548, 1549, 1477, 1482, 1481, 1862, 1170, 1479, 
       1480, 1478, 1402, 1840, 1171, 1379, 1400, 1667, 1857, 1456, 1172, 1401,
        1440, 1779, 1657, 1173, 1601, 1780, 1174, 1602, 1781, 1175, 750, 1176,
        1716, 1325, 1177}], 
      Line3DBox[{1181, 1717, 1326, 1179, 1718, 1327, 1183, 1719, 1328, 1185, 
       1720, 1329, 1187, 1660, 1721, 1442, 1330, 1534, 1678, 1876, 1535, 1443,
        1471, 1483, 1331, 1408, 1668, 1858, 1460, 1410, 1452, 756, 1409, 1464,
        1465, 1412, 1453, 1842, 1332, 1411, 1475, 1537, 1476, 1444, 1670, 
       1854, 1486, 1333, 1484, 1415, 1445, 1855, 1334, 1194, 1722, 1335, 1196,
        1723, 1336, 1198, 1724, 1337, 1200, 1726, 1339, 1202}], 
      Line3DBox[{1201, 1338, 1725, 1199, 1791, 1609, 1197, 1790, 1608, 1195, 
       1789, 1607, 1193, 1663, 1788, 1414, 1192, 1658, 1787, 1441, 1405, 1191,
        1669, 1859, 1463, 1404, 1462, 1461, 1190, 1841, 1458, 1459, 1403, 
       1457, 942, 1189, 1407, 1472, 1860, 1662, 1188, 1406, 1786, 1659, 1186, 
       1785, 1606, 1184, 1784, 1605, 1182, 1783, 1604, 1178, 1782, 1603, 
       1180}], Line3DBox[{1204, 1610, 1792, 1203, 1727, 1340, 1205, 1728, 
       1341, 1206, 1729, 1342, 1207, 1661, 1730, 1343, 1536, 1679, 1882, 1554,
        1418, 1344, 1417, 1843, 1466, 1467, 1446, 1454, 1611, 1856, 1419, 
       1468, 1469, 1447, 1455, 768, 1421, 1413, 1473, 1861, 1345, 1485, 1416, 
       1550, 1880, 1346, 1208, 1731, 1347, 1209, 1732, 1348, 1210, 1733, 1349,
        1211, 1734, 1350, 1212}], 
      Line3DBox[{1214, 1612, 1793, 1213, 1613, 1794, 1215, 1735, 1351, 1216, 
       1736, 1352, 1217, 1664, 1737, 1424, 1353, 1423, 1844, 1470, 1380, 1448,
        1354, 1425, 1845, 1420, 1530, 1531, 1532, 1878, 1427, 1533, 1547, 
       1422, 1553, 1551, 1552, 1881, 1474, 1381, 1497, 1043, 1543, 1496, 1494,
        1521, 1873, 1355, 1218, 1681, 1738, 1562, 1356, 1219, 1739, 1357, 
       1220, 1740, 1358, 1221, 1741, 1359, 1222}], 
      Line3DBox[{1224, 1614, 1795, 1223, 1615, 1796, 1225, 787, 1226, 1665, 
       1742, 1429, 1360, 1428, 1846, 1382, 1449, 1361, 1431, 1847, 1426, 1362,
        1227, 1850, 1434, 1616, 1849, 1451, 1435, 1617, 1851, 1228, 1495, 
       1618, 1867, 1522, 1383, 1501, 1047, 1544, 1500, 1673, 1743, 1527, 1363,
        1229, 1885, 1563, 1564, 1364, 1230, 1744, 1365, 1231, 1745, 1366, 
       1232}], Line3DBox[{1234, 1619, 1797, 1233, 1620, 1798, 1235, 1523, 
       1524, 1874, 1236, 1834, 1384, 1430, 1385, 1237, 1848, 1432, 1450, 1433,
        1238, 1746, 1367, 1239, 1747, 1621, 1799, 1240, 1622, 1800, 1241, 
       1623, 1801, 1242, 1498, 1502, 1499, 1877, 1545, 1243, 1529, 860, 1528, 
       1386, 1546, 1244, 1566, 1868, 1503, 1565, 1504, 1245, 1748, 1368, 1246,
        1749, 1369, 1247}], 
      Line3DBox[{1249, 1624, 1802, 1248, 1625, 1803, 1250, 1626, 1804, 1251, 
       1677, 1875, 1526, 1525, 1574, 1252, 1578, 1082, 1577, 1573, 1253, 1750,
        1370, 1254, 1751, 1627, 1805, 1255, 1628, 1806, 1256, 1629, 1807, 
       1257, 1630, 1808, 1258, 1674, 1869, 1506, 1505, 1568, 1259, 1576, 1075,
        1575, 1567, 1260, 1752, 1371, 1261, 1753, 1372, 1262}], 
      Line3DBox[{1264, 1631, 1809, 1263, 1632, 1810, 1265, 1633, 1811, 1266, 
       1634, 1812, 1267, 1635, 1813, 1268, 820, 1269, 1754, 1636, 1814, 1270, 
       1637, 1815, 1271, 1638, 1816, 1272, 1639, 1817, 1273, 1640, 1818, 1274,
        1641, 1819, 1275, 828, 1276, 1755, 1373, 1277}], 
      Line3DBox[{1291, 1438, 924, 1290, 1833, 1653, 1289, 1832, 1652, 1288, 
       1831, 1651, 1287, 1830, 1650, 1286, 1829, 1649, 1285, 1828, 1648, 1284,
        1827, 1826, 1647, 1283, 1825, 1646, 1282, 1824, 1645, 1281, 1823, 
       1644, 1280, 1822, 1643, 1279, 1821, 1642, 1278, 1666, 1820, 1436, 
       1437}]}, 
     {GrayLevel[0.2], 
      Line3DBox[{489, 681, 1682, 490, 695, 518, 1761, 710, 533, 1766, 721, 
       544, 1771, 731, 555, 1776, 741, 567, 1783, 753, 1718, 580, 764, 1727, 
       591, 1794, 776, 604, 1796, 786, 615, 1798, 794, 626, 1803, 805, 637, 
       1810, 816, 652, 1821, 831, 667}], 
      Line3DBox[{491, 682, 1683, 492, 696, 1694, 519, 711, 534, 1005, 1870, 
       1006, 722, 545, 1772, 732, 556, 1777, 742, 568, 1784, 754, 1719, 581, 
       765, 1728, 592, 777, 1735, 605, 787, 616, 1023, 1874, 1024, 795, 627, 
       1804, 806, 638, 1811, 817, 653, 1822, 832, 668}], 
      Line3DBox[{493, 683, 1684, 494, 697, 1695, 520, 1002, 1003, 1705, 1004, 
       1008, 844, 1007, 845, 982, 1864, 979, 980, 557, 1778, 743, 569, 1785, 
       755, 1720, 582, 766, 1729, 593, 778, 1736, 606, 912, 913, 1742, 915, 
       858, 1834, 1025, 859, 1028, 1875, 1026, 1027, 639, 1812, 818, 654, 
       1823, 833, 669}], 
      Line3DBox[{495, 684, 1685, 496, 698, 1696, 521, 1058, 1883, 1059, 1060, 
       1061, 977, 1863, 981, 978, 1015, 1017, 848, 1016, 849, 987, 1866, 984, 
       985, 570, 1786, 885, 886, 1721, 931, 887, 888, 1730, 594, 904, 905, 
       1737, 907, 855, 914, 1846, 856, 935, 917, 1848, 922, 918, 1087, 1088, 
       1082, 1084, 1083, 640, 1813, 819, 655, 1824, 834, 670}], 
      Line3DBox[{497, 685, 1686, 498, 699, 1697, 522, 712, 1706, 535, 1062, 
       1884, 1063, 1064, 1065, 1066, 1865, 986, 983, 1018, 1020, 1021, 1019, 
       851, 963, 1860, 889, 1036, 1038, 1037, 1876, 932, 1040, 1041, 1039, 
       1057, 1056, 1882, 898, 853, 906, 959, 1844, 958, 934, 909, 916, 1847, 
       910, 617, 796, 1746, 628, 807, 1750, 641, 820, 656, 1825, 835, 671}], 
      Line3DBox[{499, 686, 1687, 501, 700, 1698, 523, 713, 1707, 536, 723, 
       1711, 546, 870, 1837, 872, 966, 1051, 1879, 1052, 962, 879, 881, 942, 
       943, 890, 947, 946, 1858, 892, 950, 951, 897, 955, 1843, 954, 933, 900,
        908, 1845, 901, 1033, 919, 1850, 920, 618, 797, 1747, 629, 808, 1751, 
       642, 821, 1754, 657, 1826, 836, 672}], 
      Line3DBox[{503, 688, 1688, 504, 1759, 702, 525, 1763, 715, 538, 1768, 
       725, 548, 873, 1838, 734, 559, 880, 1840, 882, 745, 572, 1859, 948, 
       949, 893, 938, 757, 1842, 584, 956, 957, 902, 940, 768, 596, 903, 964, 
       1055, 1881, 780, 608, 921, 1851, 789, 620, 1800, 799, 631, 1806, 810, 
       644, 1815, 823, 659, 1828, 838, 674}], 
      Line3DBox[{505, 689, 1689, 506, 703, 1699, 526, 1764, 716, 539, 1769, 
       726, 549, 874, 1839, 875, 735, 560, 1857, 941, 852, 883, 746, 573, 
       1787, 884, 970, 971, 972, 1854, 975, 974, 894, 973, 769, 1861, 597, 
       1042, 854, 990, 1043, 1044, 609, 1045, 989, 1022, 1867, 790, 621, 1801,
        800, 632, 1807, 811, 645, 1816, 824, 660, 1829, 839, 675}], 
      Line3DBox[{507, 690, 1690, 508, 704, 1700, 527, 717, 540, 865, 1836, 
       866, 727, 550, 1773, 850, 876, 736, 561, 1779, 878, 747, 574, 1788, 
       895, 758, 1855, 585, 896, 770, 1880, 598, 988, 781, 1873, 610, 1046, 
       857, 994, 1047, 1048, 622, 1049, 993, 1877, 1030, 801, 633, 1808, 812, 
       646, 1817, 825, 661, 1830, 840, 676}], 
      Line3DBox[{509, 691, 1691, 510, 705, 1701, 528, 1011, 1012, 1708, 1013, 
       1872, 846, 867, 847, 928, 1852, 868, 877, 869, 562, 1780, 748, 575, 
       1789, 759, 1722, 586, 771, 1731, 599, 1067, 1068, 1738, 1069, 1070, 
       991, 995, 992, 1743, 1029, 1032, 860, 1031, 861, 1001, 1869, 998, 999, 
       647, 1818, 826, 662, 1831, 841, 677}], 
      Line3DBox[{511, 692, 1692, 512, 706, 1702, 529, 1078, 1886, 1079, 1080, 
       1081, 1009, 1871, 1014, 1010, 551, 1774, 737, 563, 1781, 749, 576, 
       1790, 760, 1723, 587, 772, 1732, 600, 782, 1739, 611, 1071, 1885, 1072,
        1073, 1074, 996, 1868, 1000, 997, 1085, 1086, 1075, 1077, 1076, 648, 
       1819, 827, 663, 1832, 842, 678}], 
      Line3DBox[{513, 693, 1693, 514, 707, 1703, 530, 718, 1709, 541, 728, 
       1712, 552, 738, 1714, 564, 750, 577, 1791, 761, 1724, 588, 773, 1733, 
       601, 783, 1740, 612, 791, 1744, 623, 802, 1748, 634, 813, 1752, 649, 
       828, 664, 1833, 843, 679}], 
      Line3DBox[{515, 863, 1835, 864, 516, 708, 1704, 531, 719, 1710, 542, 
       729, 1713, 553, 739, 1715, 565, 751, 1716, 578, 762, 1725, 1726, 589, 
       774, 1734, 602, 784, 1741, 613, 792, 1745, 624, 803, 1749, 635, 814, 
       1753, 650, 829, 1755, 665, 924, 925, 926}], 
      Line3DBox[{666, 830, 923, 1820, 651, 815, 1809, 636, 804, 1802, 625, 
       793, 1797, 614, 785, 1795, 603, 775, 1793, 590, 763, 1792, 579, 1717, 
       752, 1782, 566, 740, 1775, 554, 730, 1770, 543, 720, 1765, 532, 709, 
       1760, 517, 694, 1757, 488, 680, 862, 927}], 
      Line3DBox[{673, 837, 1827, 658, 822, 1814, 643, 809, 1805, 630, 798, 
       1799, 619, 788, 1849, 936, 1054, 1053, 607, 779, 1050, 1878, 1034, 911,
        961, 976, 960, 595, 767, 1856, 939, 899, 953, 952, 583, 756, 937, 891,
        945, 1841, 944, 571, 744, 1035, 965, 930, 968, 969, 1862, 967, 558, 
       733, 929, 1853, 871, 547, 724, 1767, 537, 714, 1762, 524, 701, 1758, 
       502, 687, 1756, 500}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJx0fXdAz9/3f2Vkl51kZpdQlEgXqZQiO0kIFSmRVDLKDmkrUmnvNLW7adAe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    "]],
  Axes->True,
  AxesLabel->{None, None, None},
  BoxRatios->{1, 1, 0.4},
  DisplayFunction->Identity,
  FaceGridsStyle->Automatic,
  ImageSize->{360., 293.86611844481115`},
  Method->{"DefaultBoundaryStyle" -> Directive[
      GrayLevel[0.3]], "RotationControl" -> "Globe"},
  PlotRange->{{-4, 4}, {-4, 4}, {0., 0.4999999999999949}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]},
  Ticks->{Automatic, Automatic, Automatic},
  ViewPoint->{1.1104711199061297`, -2.7079914728210697`, 1.6981272257939908`},
  
  ViewVertical->{0., 0., 1.}]], "Output",
 CellChangeTimes->{
  3.7368319570653763`*^9, {3.736832087746332*^9, 3.736832108907261*^9}, 
   3.736832186397946*^9, 3.7368324492629642`*^9, 3.7368326507571*^9, 
   3.73683348762722*^9, 3.736851195240468*^9, 3.736851253357546*^9, 
   3.7368518507835617`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MaxValue", "[", 
   RowBox[{
    RowBox[{"l", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}], "\[Element]", 
     RowBox[{"Disk", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "4"}], "]"}]}]}], "]"}], " ", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"Disk", " ", "centered", " ", "at", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"x", "=", "0"}], ",", 
       RowBox[{"y", "=", "0"}]}], "}"}]}], ",", " ", 
    RowBox[{"radius", " ", "4"}]}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.736851567531622*^9, 3.7368515854578667`*^9}, {
  3.736851679603146*^9, 3.7368517069227953`*^9}, {3.736851754882924*^9, 
  3.7368517854972363`*^9}}],

Cell[BoxData[
 FractionBox["1", "2"]], "Output",
 CellChangeTimes->{{3.736851582880045*^9, 3.736851586055036*^9}, {
   3.7368516865362473`*^9, 3.7368517072370977`*^9}, 3.736851789313683*^9, 
   3.736851858568534*^9}]
}, Open  ]]
},
WindowSize->{808, 621},
WindowMargins->{{Automatic, 266}, {Automatic, -8}},
FrontEndVersion->"10.0 for Linux x86 (64-bit) (December 4, 2014)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 334, 10, 32, "Input"],
Cell[895, 32, 910, 25, 32, "Input"],
Cell[CellGroupData[{
Cell[1830, 61, 698, 18, 32, "Input"],
Cell[2531, 81, 94038, 1532, 309, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[96606, 1618, 788, 23, 55, "Input"],
Cell[97397, 1643, 216, 4, 47, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
