% Displays the Mandelbrot set and calculates the fractal dimension of its
% boundary

Nx = 4000; %number of points on the real axis
Ny = 4000; %number of points on the imaginary axis

% x y range
xmin = -1.5;
xmax = 0.5;
ymin = -1;
ymax = 1;

% maximum number of iterations
Nmax = 128;

% Generate linearly spaced vectors
x = linspace(xmin, xmax, Nx);
y = linspace(ymin, ymax, Ny);

% Create a linear 2d grid
% X is 2d a array, column value are varying and row values are constant
% Y is 2d a array, row value are varying and column values are constant
[X, Y] = meshgrid(x, y);
Ntot = Nx*Ny;

max_abs = 4; % Maximum allowed value for the sequence

% Allocate space for output
zval = zeros(Ny, Nx);

tic %start timer

for i = 1:Ny
    for j = 1:Nx
        
%         c = x(j)+1i*y(i); % Uncomment to work with complex number (notice how much slower it is compared to the strategy below)
%         k = 1;
%         z_old=0+0i;
%         while (k <= Nmax) && (abs(z_old) < max_abs)
%             z_new = z_old^2+c;
%             z_old = z_new;
%             k = k+1;
%         end


    a = x(j);
    b = y(i);
    x_old = 0;
    y_old = 0;
    k = 1;
    while (k <= Nmax) && ((x_old)^2+(y_old)^2) < max_abs
        x_new = ((x_old)^2 - (y_old)^2) + a;
        y_new = 2*((x_old))*(y_old) + b;
        x_old = x_new;
        y_old = y_new;
        k = k+1;
    end
    
    
         zval(i,j) = k-1;
    end
end
toc %stop

h=figure;
% cmap = flipud(hot(Nmax));
% colormap(cmap);
pcolor(X,Y,zval);
axis equal
shading flat
set(gca,'YDir','normal');
xlabel('Re(c)');
ylabel('Im(c)');
xlim([xmin xmax])
ylim([ymin ymax])
box on
%caxis([Nmax/10,Nmax])
colormap hot
colorbar

%% Fractal dimension calculation

figure
C = contour(x,y,zval,[Nmax Nmax],'b');
axis equal
grid on

% Correction to the contour object: exclude points which are out of the
% domain

excl_points = 0;
flag_excl = zeros(1,size(C,2));
for i = 1:size(C,2)
    if C(1,i)>xmax || C(1,i)<xmin || C(2,i)>ymax || C(2,i)<ymin
       excl_points = excl_points +1;
       flag_excl(i) = 1;
    end
end

C_corr = zeros(2,size(C,2)-excl_points);
j = 0;
for i = 1:size(C,2)
    if flag_excl(i)==0;
       j = j+1;
       C_corr(:,j) = C(:,i);
    end
end

%%Plots the corrected contour, and calculate the fractal dimension

figure
plot(C_corr(1,:),C_corr(2,:),'k.')

N_eps = size(C,2);
dx = (xmax-xmin)/Nx;
dy = (ymax-ymin)/Ny;
f_dim = log(N_eps)/log(1/dx);
display(['Box-counting dimension of Mandelbrot boundary set is ~ ',sprintf('%0.5g',f_dim)])

%% Save points

% save(['corr_dim_n_',num2str(Nx)],'N_eps','dx','f_dim')

%% Save the figure in pdf format

% set(h,'Units','Inches');
% pos = get(h,'Position');
% set(h,'PaperPositionMode','Auto','PaperUnits','Inches','PaperSize',[pos(3), pos(4)-0.5])
% print(h,'mandelbrot_set','-dpdf','-r200','-bestfit')