% The goal is to determine the fraction of values of 'a' between 3.57 and 4 that lead to chaotic maps.

figure;

subplot(1,2,1); grid on; box on; hold on; % Subplot with 'evolution plot'
set(gca,'FontSize',14); xlabel('n'); ylabel('x_n');
xlim([0,50]); ylim([0,1]); Nplot=50; % Nplot is the number of iterations plotted

subplot(1,2,2); grid on; box on; hold on; % Subplot with DFT
set(gca,'FontSize',14); xlabel('Frequency'); ylabel('Amplitude');
xlim([-0.01,0.51]); ylim([0,0.1]);



global a; % Parameter of logistic map
x0=0.5;  % Initial condition
N=10000; % Number of iterations for a map
N_total = 100; % Number of values of 'a' to explore 
N_chaotic = 0; % Number of chaotic maps encountered

for i=1:N_total % Loop on different values of 'a'

	a = 3.57 + 0.43*rand(); % Random value uniformly distributed on [3.57,4]

	x = compute_map(x0,N-1);

	subplot(1,2,1);	cla;
	title(sprintf('a=%.3f',a));
	plot(linspace(0,Nplot-1,Nplot),x(1:Nplot),'-k.'); % Evolution plot of first Nplot iterations


	DFT = fft(x); % Fast Fourier transform
	DFT = abs(DFT/N); % Amplitude
	DFT = DFT(2:N/2); % Single-sided spectrum
	freq = (1:N/2-1)/N; % Frequencies


	subplot(1,2,2); cla;
	if max(DFT)>0.03 % If the max DFT amplitude is above a threshold, the map is periodic (the threshold 0.03 was determined empirically)
		title('Periodic');	
	else
		N_chaotic = N_chaotic + 1; % Count the number of chaotic maps
		title('Chaotic');	
	end	
	plot(freq,DFT,'-b'); % DFT plot


	pause(2./i); % For user to see
end

disp(sprintf('The fraction of chaotic systems is %.2f',N_chaotic./N_total));



