% Animates the plots of f^{2^r}
% question_num (character) : either 'a', 'c', or 'd' to make the animation associated with that question
function animation_f2r(question_num)

A = [2, 3.2361, 3.4986, 3.5546, 3.5667]; % A_r
% A = [2, 3.23606797749979, 3.4985616993277, 3.55464086276883, 3.56666737985627, 3.56924353163711, 3.56979529374995, 3.56991346542235, 3.56993877423331, 3.56994419460806, 3.56994535548647]; % More digits

ac = 3.5699456718; % Value of a where chaos happens

alpha=-2.5029; % Feigenbaum constant

figure;
for r=0:3 % Loop from f^{2^0} to f^{2^3}

	if question_num=='a' % For question a

		a=ac; % a fixed, no animation
		x = linspace(0,1,5000);	% No zoom, range [0,1]

	elseif question_num=='c' % For question c
		
		a = linspace(0,ac,50); % Animation on [0,ac]
		x = linspace(0,1,5000); % No zoom, range [0,1]

	elseif question_num=='d' % For question d

		if r==0 % Animation of a
			a = linspace(1,A(1),50);
		else 
			a = linspace(A(r),A(r+1),50);
		end

		x = linspace(0.5-0.5/abs(alpha)^r,0.5+0.5/abs(alpha)^r,1000); % Zoom depends on r
	
	end

	
	subplot(2,2,r+1); grid on; box on; hold on; % Figure subdivided into 2*2 grid of subplots
	set(gca,'FontSize',14); xlabel('x');
	xlim([x(1),x(end)]); ylim([x(1),x(end)]);

	for i=1:numel(a) % Loop on value of a, for animation
		cla; % Clear subplot
		title( sprintf('$f^{%d}(%.2f,x)$',2^r,a(i)),'Interpreter','latex'); % Update value of a in title

		plot(x,x,':r'); % Diagonal y=x
		plot(x, diffEq(2^r,a(i),x), '-k' ); % Plot y=f^{2^r}(a,x)

		pause(0.1); % Time of each frame in animation
	end
end



end