(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     22247,        731]
NotebookOptionsPosition[     19517,        657]
NotebookOutlinePosition[     19852,        672]
CellTagsIndexPosition[     19809,        669]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{"a_", ",", "x_"}], "]"}], ":=", 
   RowBox[{"a", "-", 
    RowBox[{"x", "^", "2"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"h2", "[", 
    RowBox[{"a_", ",", "x_"}], "]"}], ":=", 
   RowBox[{"h", "[", 
    RowBox[{"a", ",", 
     RowBox[{"h", "[", 
      RowBox[{"a", ",", "x"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"h3", "[", 
    RowBox[{"a_", ",", "x_"}], "]"}], ":=", 
   RowBox[{"h", "[", 
    RowBox[{"a", ",", 
     RowBox[{"h2", "[", 
      RowBox[{"a", ",", "x"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"h4", "[", 
    RowBox[{"a_", ",", "x_"}], "]"}], ":=", 
   RowBox[{"h", "[", 
    RowBox[{"a", ",", 
     RowBox[{"h3", "[", 
      RowBox[{"a", ",", "x"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.861253413026165*^9, 
  3.861253479279314*^9}},ExpressionUUID->"c61b9ec4-de54-463b-8b2b-\
8b24fb7bba5f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Expand", "[", 
  RowBox[{"h4", "[", 
   RowBox[{"A2", ",", "0"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.861253486049543*^9, 
  3.861253493046892*^9}},ExpressionUUID->"1b1d7ec8-1969-4954-85b3-\
b8e1f28841d3"],

Cell[BoxData[
 RowBox[{"A2", "-", 
  SuperscriptBox["A2", "2"], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["A2", "3"]}], "-", 
  RowBox[{"5", " ", 
   SuperscriptBox["A2", "4"]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["A2", "5"]}], "-", 
  RowBox[{"6", " ", 
   SuperscriptBox["A2", "6"]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["A2", "7"]}], "-", 
  SuperscriptBox["A2", "8"]}]], "Output",
 CellChangeTimes->{
  3.861253496881152*^9},ExpressionUUID->"7a536837-6fbc-48d8-ae18-\
2b9222255252"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"h4", "[", 
     RowBox[{"A2", ",", "0"}], "]"}], "\[Equal]", "0"}], ",", "A2"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.861253501693677*^9, 
  3.8612535184079*^9}},ExpressionUUID->"c9a05aa1-1e5e-42aa-b5e5-00a0c9d789a4"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"A2", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.2822713907669139`"}], "-", 
      RowBox[{"0.5300606175785253`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"A2", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.2822713907669139`"}], "+", 
      RowBox[{"0.5300606175785253`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"A2", "\[Rule]", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"A2", "\[Rule]", 
     RowBox[{"0.15652016683375514`", "\[VeryThinSpace]", "-", 
      RowBox[{"1.0322471089228318`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"A2", "\[Rule]", 
     RowBox[{"0.15652016683375514`", "\[VeryThinSpace]", "+", 
      RowBox[{"1.0322471089228318`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"A2", "\[Rule]", "0.9999999999999994`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"A2", "\[Rule]", "1.310702641336833`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"A2", "\[Rule]", "1.9407998065294856`"}], "}"}]}], 
  "}"}]], "Output",
 CellChangeTimes->{{3.8612535109202013`*^9, 
  3.8612535192237387`*^9}},ExpressionUUID->"bf3e225a-91f7-4aee-bc3e-\
770c0064b9ae"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"pol", "=", 
  RowBox[{"Expand", "[", 
   RowBox[{
    RowBox[{"\[Alpha]", "^", "2"}], " ", 
    RowBox[{"h4", "[", 
     RowBox[{"A2", ",", 
      FractionBox["x", 
       RowBox[{"\[Alpha]", "^", "2"}]]}], "]"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.8612536649597692`*^9, 3.861253691324656*^9}, {
  3.861253725789218*^9, 3.861253729859847*^9}, {3.861253846516038*^9, 
  3.861253875179179*^9}},ExpressionUUID->"e7d3434b-23ed-4b52-be1d-\
fe6f434f7e22"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   FractionBox[
    SuperscriptBox["x", "16"], 
    SuperscriptBox["\[Alpha]", "30"]]}], "+", 
  FractionBox[
   RowBox[{"8", " ", "A2", " ", 
    SuperscriptBox["x", "14"]}], 
   SuperscriptBox["\[Alpha]", "26"]], "+", 
  FractionBox[
   RowBox[{"4", " ", "A2", " ", 
    SuperscriptBox["x", "12"]}], 
   SuperscriptBox["\[Alpha]", "22"]], "-", 
  FractionBox[
   RowBox[{"28", " ", 
    SuperscriptBox["A2", "2"], " ", 
    SuperscriptBox["x", "12"]}], 
   SuperscriptBox["\[Alpha]", "22"]], "-", 
  FractionBox[
   RowBox[{"24", " ", 
    SuperscriptBox["A2", "2"], " ", 
    SuperscriptBox["x", "10"]}], 
   SuperscriptBox["\[Alpha]", "18"]], "+", 
  FractionBox[
   RowBox[{"56", " ", 
    SuperscriptBox["A2", "3"], " ", 
    SuperscriptBox["x", "10"]}], 
   SuperscriptBox["\[Alpha]", "18"]], "+", 
  FractionBox[
   RowBox[{"2", " ", "A2", " ", 
    SuperscriptBox["x", "8"]}], 
   SuperscriptBox["\[Alpha]", "14"]], "-", 
  FractionBox[
   RowBox[{"6", " ", 
    SuperscriptBox["A2", "2"], " ", 
    SuperscriptBox["x", "8"]}], 
   SuperscriptBox["\[Alpha]", "14"]], "+", 
  FractionBox[
   RowBox[{"60", " ", 
    SuperscriptBox["A2", "3"], " ", 
    SuperscriptBox["x", "8"]}], 
   SuperscriptBox["\[Alpha]", "14"]], "-", 
  FractionBox[
   RowBox[{"70", " ", 
    SuperscriptBox["A2", "4"], " ", 
    SuperscriptBox["x", "8"]}], 
   SuperscriptBox["\[Alpha]", "14"]], "-", 
  FractionBox[
   RowBox[{"8", " ", 
    SuperscriptBox["A2", "2"], " ", 
    SuperscriptBox["x", "6"]}], 
   SuperscriptBox["\[Alpha]", "10"]], "+", 
  FractionBox[
   RowBox[{"24", " ", 
    SuperscriptBox["A2", "3"], " ", 
    SuperscriptBox["x", "6"]}], 
   SuperscriptBox["\[Alpha]", "10"]], "-", 
  FractionBox[
   RowBox[{"80", " ", 
    SuperscriptBox["A2", "4"], " ", 
    SuperscriptBox["x", "6"]}], 
   SuperscriptBox["\[Alpha]", "10"]], "+", 
  FractionBox[
   RowBox[{"56", " ", 
    SuperscriptBox["A2", "5"], " ", 
    SuperscriptBox["x", "6"]}], 
   SuperscriptBox["\[Alpha]", "10"]], "-", 
  FractionBox[
   RowBox[{"4", " ", 
    SuperscriptBox["A2", "2"], " ", 
    SuperscriptBox["x", "4"]}], 
   SuperscriptBox["\[Alpha]", "6"]], "+", 
  FractionBox[
   RowBox[{"16", " ", 
    SuperscriptBox["A2", "3"], " ", 
    SuperscriptBox["x", "4"]}], 
   SuperscriptBox["\[Alpha]", "6"]], "-", 
  FractionBox[
   RowBox[{"36", " ", 
    SuperscriptBox["A2", "4"], " ", 
    SuperscriptBox["x", "4"]}], 
   SuperscriptBox["\[Alpha]", "6"]], "+", 
  FractionBox[
   RowBox[{"60", " ", 
    SuperscriptBox["A2", "5"], " ", 
    SuperscriptBox["x", "4"]}], 
   SuperscriptBox["\[Alpha]", "6"]], "-", 
  FractionBox[
   RowBox[{"28", " ", 
    SuperscriptBox["A2", "6"], " ", 
    SuperscriptBox["x", "4"]}], 
   SuperscriptBox["\[Alpha]", "6"]], "+", 
  FractionBox[
   RowBox[{"8", " ", 
    SuperscriptBox["A2", "3"], " ", 
    SuperscriptBox["x", "2"]}], 
   SuperscriptBox["\[Alpha]", "2"]], "-", 
  FractionBox[
   RowBox[{"16", " ", 
    SuperscriptBox["A2", "4"], " ", 
    SuperscriptBox["x", "2"]}], 
   SuperscriptBox["\[Alpha]", "2"]], "+", 
  FractionBox[
   RowBox[{"24", " ", 
    SuperscriptBox["A2", "5"], " ", 
    SuperscriptBox["x", "2"]}], 
   SuperscriptBox["\[Alpha]", "2"]], "-", 
  FractionBox[
   RowBox[{"24", " ", 
    SuperscriptBox["A2", "6"], " ", 
    SuperscriptBox["x", "2"]}], 
   SuperscriptBox["\[Alpha]", "2"]], "+", 
  FractionBox[
   RowBox[{"8", " ", 
    SuperscriptBox["A2", "7"], " ", 
    SuperscriptBox["x", "2"]}], 
   SuperscriptBox["\[Alpha]", "2"]], "+", 
  RowBox[{"A2", " ", 
   SuperscriptBox["\[Alpha]", "2"]}], "-", 
  RowBox[{
   SuperscriptBox["A2", "2"], " ", 
   SuperscriptBox["\[Alpha]", "2"]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["A2", "3"], " ", 
   SuperscriptBox["\[Alpha]", "2"]}], "-", 
  RowBox[{"5", " ", 
   SuperscriptBox["A2", "4"], " ", 
   SuperscriptBox["\[Alpha]", "2"]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["A2", "5"], " ", 
   SuperscriptBox["\[Alpha]", "2"]}], "-", 
  RowBox[{"6", " ", 
   SuperscriptBox["A2", "6"], " ", 
   SuperscriptBox["\[Alpha]", "2"]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["A2", "7"], " ", 
   SuperscriptBox["\[Alpha]", "2"]}], "-", 
  RowBox[{
   SuperscriptBox["A2", "8"], " ", 
   SuperscriptBox["\[Alpha]", "2"]}]}]], "Output",
 CellChangeTimes->{
  3.8612536917059*^9, {3.861253726205923*^9, 3.861253730172098*^9}, {
   3.8612538491063004`*^9, 
   3.861253875564555*^9}},ExpressionUUID->"afab5838-7e69-4d17-923f-\
df11f66a077e"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Collect", "[", 
  RowBox[{"pol", ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.8612537309026833`*^9, 
  3.861253736794598*^9}},ExpressionUUID->"7bb67acc-d3f3-4361-9d0d-\
297fe34809d9"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   SuperscriptBox["x", "12"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"4", " ", "A2"}], 
      SuperscriptBox["\[Alpha]", "22"]], "-", 
     FractionBox[
      RowBox[{"28", " ", 
       SuperscriptBox["A2", "2"]}], 
      SuperscriptBox["\[Alpha]", "22"]]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "10"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"24", " ", 
        SuperscriptBox["A2", "2"]}], 
       SuperscriptBox["\[Alpha]", "18"]]}], "+", 
     FractionBox[
      RowBox[{"56", " ", 
       SuperscriptBox["A2", "3"]}], 
      SuperscriptBox["\[Alpha]", "18"]]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "8"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"2", " ", "A2"}], 
      SuperscriptBox["\[Alpha]", "14"]], "-", 
     FractionBox[
      RowBox[{"6", " ", 
       SuperscriptBox["A2", "2"]}], 
      SuperscriptBox["\[Alpha]", "14"]], "+", 
     FractionBox[
      RowBox[{"60", " ", 
       SuperscriptBox["A2", "3"]}], 
      SuperscriptBox["\[Alpha]", "14"]], "-", 
     FractionBox[
      RowBox[{"70", " ", 
       SuperscriptBox["A2", "4"]}], 
      SuperscriptBox["\[Alpha]", "14"]]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "6"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"8", " ", 
        SuperscriptBox["A2", "2"]}], 
       SuperscriptBox["\[Alpha]", "10"]]}], "+", 
     FractionBox[
      RowBox[{"24", " ", 
       SuperscriptBox["A2", "3"]}], 
      SuperscriptBox["\[Alpha]", "10"]], "-", 
     FractionBox[
      RowBox[{"80", " ", 
       SuperscriptBox["A2", "4"]}], 
      SuperscriptBox["\[Alpha]", "10"]], "+", 
     FractionBox[
      RowBox[{"56", " ", 
       SuperscriptBox["A2", "5"]}], 
      SuperscriptBox["\[Alpha]", "10"]]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", 
        SuperscriptBox["A2", "2"]}], 
       SuperscriptBox["\[Alpha]", "6"]]}], "+", 
     FractionBox[
      RowBox[{"16", " ", 
       SuperscriptBox["A2", "3"]}], 
      SuperscriptBox["\[Alpha]", "6"]], "-", 
     FractionBox[
      RowBox[{"36", " ", 
       SuperscriptBox["A2", "4"]}], 
      SuperscriptBox["\[Alpha]", "6"]], "+", 
     FractionBox[
      RowBox[{"60", " ", 
       SuperscriptBox["A2", "5"]}], 
      SuperscriptBox["\[Alpha]", "6"]], "-", 
     FractionBox[
      RowBox[{"28", " ", 
       SuperscriptBox["A2", "6"]}], 
      SuperscriptBox["\[Alpha]", "6"]]}], ")"}]}], "+", 
  RowBox[{
   SuperscriptBox["x", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     FractionBox[
      RowBox[{"8", " ", 
       SuperscriptBox["A2", "3"]}], 
      SuperscriptBox["\[Alpha]", "2"]], "-", 
     FractionBox[
      RowBox[{"16", " ", 
       SuperscriptBox["A2", "4"]}], 
      SuperscriptBox["\[Alpha]", "2"]], "+", 
     FractionBox[
      RowBox[{"24", " ", 
       SuperscriptBox["A2", "5"]}], 
      SuperscriptBox["\[Alpha]", "2"]], "-", 
     FractionBox[
      RowBox[{"24", " ", 
       SuperscriptBox["A2", "6"]}], 
      SuperscriptBox["\[Alpha]", "2"]], "+", 
     FractionBox[
      RowBox[{"8", " ", 
       SuperscriptBox["A2", "7"]}], 
      SuperscriptBox["\[Alpha]", "2"]]}], ")"}]}], "-", 
  FractionBox[
   SuperscriptBox["x", "16"], 
   SuperscriptBox["\[Alpha]", "30"]], "+", 
  FractionBox[
   RowBox[{"8", " ", "A2", " ", 
    SuperscriptBox["x", "14"]}], 
   SuperscriptBox["\[Alpha]", "26"]], "+", 
  RowBox[{"A2", " ", 
   SuperscriptBox["\[Alpha]", "2"]}], "-", 
  RowBox[{
   SuperscriptBox["A2", "2"], " ", 
   SuperscriptBox["\[Alpha]", "2"]}], "+", 
  RowBox[{"2", " ", 
   SuperscriptBox["A2", "3"], " ", 
   SuperscriptBox["\[Alpha]", "2"]}], "-", 
  RowBox[{"5", " ", 
   SuperscriptBox["A2", "4"], " ", 
   SuperscriptBox["\[Alpha]", "2"]}], "+", 
  RowBox[{"6", " ", 
   SuperscriptBox["A2", "5"], " ", 
   SuperscriptBox["\[Alpha]", "2"]}], "-", 
  RowBox[{"6", " ", 
   SuperscriptBox["A2", "6"], " ", 
   SuperscriptBox["\[Alpha]", "2"]}], "+", 
  RowBox[{"4", " ", 
   SuperscriptBox["A2", "7"], " ", 
   SuperscriptBox["\[Alpha]", "2"]}], "-", 
  RowBox[{
   SuperscriptBox["A2", "8"], " ", 
   SuperscriptBox["\[Alpha]", "2"]}]}]], "Output",
 CellChangeTimes->{{3.8612537337344723`*^9, 3.861253737020197*^9}, {
  3.861253850286632*^9, 
  3.8612538765863457`*^9}},ExpressionUUID->"c5c62561-0590-4748-933e-\
d7501a178832"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"0.5", "*", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"8", " ", 
      SuperscriptBox["A2", "3"]}], "-", 
     RowBox[{"16", " ", 
      SuperscriptBox["A2", "4"]}], "+", 
     RowBox[{"24", " ", 
      SuperscriptBox["A2", "5"]}], "-", 
     RowBox[{"24", " ", 
      SuperscriptBox["A2", "6"]}], "+", 
     RowBox[{"8", " ", 
      SuperscriptBox["A2", "7"]}]}], ")"}]}], "/.", 
  RowBox[{"{", 
   RowBox[{"A2", "\[Rule]", "1.3107"}], "}"}]}]], "Input",
 CellChangeTimes->{{3.8612539606490517`*^9, 
  3.861253988192725*^9}},ExpressionUUID->"92f404b5-681e-4f61-a759-\
84b38eff4df8"],

Cell[BoxData[
 RowBox[{"-", "2.4443323298023216`"}]], "Output",
 CellChangeTimes->{
  3.861253989512368*^9},ExpressionUUID->"e11b190c-ce4a-4b4c-bb8e-\
ee2c1a6e9bcd"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",Expressi\
onUUID->"13bb51b1-e974-4ead-b33e-63e453a0524d"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{"1.", "\[Equal]", 
    RowBox[{"4", " ", "b", " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "b"}], ")"}], "^", "3"}]}]}], ",", "b"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8612546060508537`*^9, 
  3.8612546432101517`*^9}},ExpressionUUID->"ac6e4a8d-0f88-447a-b15b-\
1cddbdc3554e"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"b", "\[Rule]", 
     RowBox[{"-", "1.5449333865289177`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.8075914406301773`"}], "-", 
      RowBox[{"0.5986920151383036`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.8075914406301773`"}], "+", 
      RowBox[{"0.5986920151383036`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"b", "\[Rule]", "0.1601162677892719`"}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{{3.861254638075583*^9, 
  3.861254644116809*^9}},ExpressionUUID->"0d91a60c-c013-45eb-8ed5-\
545c6e233e5d"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<Global`*\>\"", "]"}], ";"}]], "Input",Expressi\
onUUID->"77b4066c-63b5-42c0-8884-93ce336996b6"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f1", "[", 
    RowBox[{"a_", ",", "x_"}], "]"}], ":=", 
   RowBox[{"a", "-", 
    RowBox[{"x", "^", "4"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f2", "[", 
    RowBox[{"a_", ",", "x_"}], "]"}], ":=", 
   RowBox[{"f1", "[", 
    RowBox[{"a", ",", 
     RowBox[{"f1", "[", 
      RowBox[{"a", ",", "x"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f3", "[", 
    RowBox[{"a_", ",", "x_"}], "]"}], ":=", 
   RowBox[{"f1", "[", 
    RowBox[{"a", ",", 
     RowBox[{"f2", "[", 
      RowBox[{"a", ",", "x"}], "]"}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f4", "[", 
    RowBox[{"a_", ",", "x_"}], "]"}], ":=", 
   RowBox[{"f1", "[", 
    RowBox[{"a", ",", 
     RowBox[{"f3", "[", 
      RowBox[{"a", ",", "x"}], "]"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]"}], "Input",
 CellChangeTimes->{{3.861255237245801*^9, 
  3.8612552645537167`*^9}},ExpressionUUID->"f60a7edb-f91d-4633-9b2e-\
3cec6c64316f"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f1", "[", 
     RowBox[{"a", ",", "0"}], "]"}], "\[Equal]", "0"}], ",", "a"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.861255269232744*^9, 
  3.861255296819221*^9}},ExpressionUUID->"a9ec9720-ffa4-41b2-9178-\
4a351b537085"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"a", "\[Rule]", "0"}], "}"}], "}"}]], "Output",
 CellChangeTimes->{{3.8612552868631353`*^9, 3.861255297937311*^9}, 
   3.8612553289653797`*^9},ExpressionUUID->"e194a787-395e-4a49-b480-\
eedc7920a4c1"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f2", "[", 
     RowBox[{"a", ",", "0"}], "]"}], "\[Equal]", "0."}], ",", "a"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8612553335040503`*^9, 
  3.861255350416543*^9}},ExpressionUUID->"28c67c07-bc3e-4501-b6ea-\
8d5ab578a234"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.5`"}], "-", 
      RowBox[{"0.8660254037844386`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", "\[Rule]", 
     RowBox[{
      RowBox[{"-", "0.5`"}], "+", 
      RowBox[{"0.8660254037844386`", " ", "\[ImaginaryI]"}]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", "\[Rule]", "0.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", "\[Rule]", "1.`"}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{{3.8612553339530773`*^9, 
  3.861255350902523*^9}},ExpressionUUID->"053dbabd-ad30-438b-8712-\
978eba188f85"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSolve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f4", "[", 
     RowBox[{"a", ",", "0"}], "]"}], "\[Equal]", "0"}], ",", "a", ",", 
   "Reals"}], "]"}]], "Input",
 CellChangeTimes->{{3.861255336160125*^9, 
  3.861255343786131*^9}},ExpressionUUID->"0d0b6dfd-7b50-4c42-8c81-\
89281e120327"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", "\[Rule]", "1.`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", "\[Rule]", "1.1457142071597122`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", "\[Rule]", "1.2561223772224401`"}], "}"}]}], "}"}]], "Output",\

 CellChangeTimes->{{3.861255336593054*^9, 
  3.8612553442538757`*^9}},ExpressionUUID->"331c23bc-5d71-40b2-85cf-\
8bf665d763bc"]
}, Open  ]]
},
WindowSize->{1920, 1015},
WindowMargins->{{0, Automatic}, {0, Automatic}},
FrontEndVersion->"11.1 for Linux x86 (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 1017, 33, 107, "Input", "ExpressionUUID" -> \
"c61b9ec4-de54-463b-8b2b-8b24fb7bba5f"],
Cell[CellGroupData[{
Cell[1600, 57, 239, 6, 35, "Input", "ExpressionUUID" -> \
"1b1d7ec8-1969-4954-85b3-b8e1f28841d3"],
Cell[1842, 65, 508, 16, 33, "Output", "ExpressionUUID" -> \
"7a536837-6fbc-48d8-ae18-2b9222255252"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2387, 86, 297, 8, 35, "Input", "ExpressionUUID" -> \
"c9a05aa1-1e5e-42aa-b5e5-00a0c9d789a4"],
Cell[2687, 96, 1259, 32, 35, "Output", "ExpressionUUID" -> \
"bf3e225a-91f7-4aee-bc3e-770c0064b9ae"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3983, 133, 481, 12, 48, "Input", "ExpressionUUID" -> \
"e7d3434b-23ed-4b52-be1d-fe6f434f7e22"],
Cell[4467, 147, 4501, 145, 101, "Output", "ExpressionUUID" -> \
"afab5838-7e69-4d17-923f-df11f66a077e"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9005, 297, 213, 5, 35, "Input", "ExpressionUUID" -> \
"7bb67acc-d3f3-4361-9d0d-297fe34809d9"],
Cell[9221, 304, 4518, 148, 108, "Output", "ExpressionUUID" -> \
"c5c62561-0590-4748-933e-d7501a178832"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13776, 457, 619, 19, 37, "Input", "ExpressionUUID" -> \
"92f404b5-681e-4f61-a759-84b38eff4df8"],
Cell[14398, 478, 165, 4, 33, "Output", "ExpressionUUID" -> \
"e11b190c-ce4a-4b4c-bb8e-ee2c1a6e9bcd"]
}, Open  ]],
Cell[14578, 485, 151, 3, 37, "Input", "ExpressionUUID" -> \
"13bb51b1-e974-4ead-b33e-63e453a0524d"],
Cell[CellGroupData[{
Cell[14754, 492, 362, 11, 35, "Input", "ExpressionUUID" -> \
"ac6e4a8d-0f88-447a-b15b-1cddbdc3554e"],
Cell[15119, 505, 744, 21, 35, "Output", "ExpressionUUID" -> \
"0d91a60c-c013-45eb-8ed5-545c6e233e5d"]
}, Open  ]],
Cell[15878, 529, 151, 3, 37, "Input", "ExpressionUUID" -> \
"77b4066c-63b5-42c0-8884-93ce336996b6"],
Cell[16032, 534, 1050, 34, 130, "Input", "ExpressionUUID" -> \
"f60a7edb-f91d-4633-9b2e-3cec6c64316f"],
Cell[CellGroupData[{
Cell[17107, 572, 298, 9, 35, "Input", "ExpressionUUID" -> \
"a9ec9720-ffa4-41b2-9178-4a351b537085"],
Cell[17408, 583, 256, 6, 33, "Output", "ExpressionUUID" -> \
"e194a787-395e-4a49-b480-eedc7920a4c1"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17701, 594, 301, 9, 35, "Input", "ExpressionUUID" -> \
"28c67c07-bc3e-4501-b6ea-8d5ab578a234"],
Cell[18005, 605, 661, 19, 35, "Output", "ExpressionUUID" -> \
"053dbabd-ad30-438b-8712-978eba188f85"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18703, 629, 314, 9, 35, "Input", "ExpressionUUID" -> \
"0d0b6dfd-7b50-4c42-8c81-89281e120327"],
Cell[19020, 640, 481, 14, 35, "Output", "ExpressionUUID" -> \
"331c23bc-5d71-40b2-85cf-8bf665d763bc"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

