% Plots Trajectories
% X : matrix size(n,3) contain [X(t),Y(t),Z(t)] for n values of t
function plotTrajectory(XEuler, XRK4, Xode45)

figure; title('Trajectory')
hold on
labels = {}; % Just comment out the lines you don't want to plot and the legend should adapt.
	plot3(XEuler(:,1),XEuler(:,2),XEuler(:,3),'r'); labels= [labels 'Euler'];
	plot3(XRK4(:,1),XRK4(:,2),XRK4(:,3),'k'); labels= [labels 'RK4'];
	plot3(Xode45(:,1),Xode45(:,2),Xode45(:,3),'b'); labels= [labels 'ode45'];
legend(labels)
xlabel('x'); ylabel('y'); zlabel('z')

% To animate the plot
% comet3(XRK4(:,1),XRK4(:,2),XRK4(:,3),0.1);
hold off;

end
