% Finds the amplitudes of X(:,3) and rearanges into consecutive peak amplitude pairs [z1,z2 ; z2,z3 ; ... ]
% pairs : matrix size (N,2) in form [z1,z2 ; z2,z3 ; ... ] where zn is the amplitude of the nth peak
% X : matrix size(n,3) contain [X(t),Y(t),Z(t)] for n values of t
function pairs = makePairs(X)

pks=findpeaks(X(:,3)); % list of all peak amplitudes for the third variable Z

N=size(pks,1)-1; % upper limit for the loop
pairs=zeros(N,2); % Initialise matrix that will contain consecutive pairs [z1,z2 ; z2,z3 ; ... ]
for n=1:N
    pairs(n,1)=pks(n);
    pairs(n,2)=pks(n+1);
end

end

