% Chose the different parameters, then the operations to launch (plot the trajectories? compare different dt? ...)

% Parameters 
global sigma b r; % Global so that function diffEq(t,X) can use them
sigma=10; % Prandtl number
b=8./3.;
% Rayleigh number
r=10; % Stable


%% Stable solution (a and c)

%Initial Condition
X0 = [0,1,0];

dt=0.01; % Time step
iter=2000; % Number of integration iterations


[XEuler, XRK4, Xode45] = integration(X0,dt,iter);
plotTrajectory(XEuler, XRK4, Xode45);

%% Order of the method (b)

%Initial Condition
X0 = [0,1,0];

tf=2; 
vec_iter=[100000,30000,10000,3000,1000,300,100]; 
vec_dt=tf./vec_iter; 
compare_dt(X0, vec_dt, vec_iter);

%% Transient chaos (d)

r=21; 
X0 = [10,0,10];
dt=0.01; % Time step
iter=2000; % Number of integration iterations

[XEuler, XRK4, Xode45] = integration(X0,dt,iter);
plotTrajectory(XEuler, XRK4, Xode45); %Change plotTrajectory to plot only XRK4 or Xode45 

%% Chaos (e)
r=28;
X0 = [0,1,0];
dt=0.01; % Time step
iter=3000; % Number of integration iterations

[~, XRK4, ~] = integration(X0,dt,iter);
figure
title('Trajectory')
xlabel('x')
ylabel('z')
hold on
comet(XRK4(:,1),XRK4(:,3),0.9)
hold off

pause(1)
t=0:dt:iter*dt;
figure 
plot(t,XRK4(:,2),'k')
xlabel('t')
ylabel('y')

%% Sensitivity to initial conditions (f)
r=28;
X0 = [0,1,0];
dt=0.015; % Time step
iter=2000; % Number of integration iterations

dX0=10^(-3);
nSimul=100;
compare_X0(X0,dt,iter,dX0,nSimul)

%% Periodic behavior (g)
r=400;
X0 = [-54,-59,485];
dt=0.01; % Time step
iter=2000; % Number of integration iterations

[XEuler, XRK4, Xode45] = integration(X0,dt,iter);
plotTrajectory(XEuler, XRK4, Xode45); %Change plotTrajectory to plot only XRK4 or Xode45 

%% Lorenz Map (h)
r=28;
X0 = [0,1,0];
dt=0.005; % Time step
iter=50000; % Number of integration iterations

[XEuler, XRK4, Xode45] = integration(X0,dt,iter);

LorenzMap(XEuler, XRK4, Xode45)

