% Compares the trajectories produces by different dt.
% X0 : row vector initial condition = [X0,Y0,Z0]
% dt : row vector, time steps for integrations (smallest to biggest)
% iter : row vector, number of iterations for integrations (corresponding so that same tf)
function compare_dt(X0,dt,iter)

[XEuler, XRK4, Xode45] = integration(X0,dt(1),iter(1)); % Simulation for the smallest dt (our most precise solution to compare with)
finalEuler = XEuler(end,:); % Final position of the most precise solution
finalRK4 = XRK4(end,:);
finalode45 = Xode45(end,:);

N = size(dt,2); % Number of simulations
distanceEuler = zeros(N-1,1); % Distances to the most precise solution
distanceRK4 = zeros(N-1,1);
for i=2:N
	[XEuler, XRK4, ~] = integration(X0,dt(i),iter(i)); % Actual simulation
	distanceEuler(i-1) = distance( XEuler(end,:),finalEuler );
	distanceRK4(i-1) = distance(XRK4(end,:),finalRK4);
end


figure; %title('Distance to most precise solution')
hold on;
labels = {}; % Just comment out the lines you don't want to plot and the legend should adapt.
	plot(dt(2:end),distanceEuler,'.r-'); labels= [labels 'Euler'];
	plot(dt(2:end),distanceRK4,'.k-'); labels= [labels 'RK4'];
    plot(dt(2:end),12*dt(2:end)); labels= [labels 'slope 1'];
    plot(dt(2:end),3.9*dt(2:end).^4); labels= [labels 'slope 4'];
hold off;
set(gca,'FontSize',14,'XScale','log','YScale','log');
grid on;
legend(labels);
xlabel('\Delta t'); ylabel('Final position distance');

% distance(finalode45,finalEuler)	% Compare with ode45
% distance(finalode45,finalRK4)

end
