% Compares the final positions of many simulations with close initial conditions (to test chaos).
% X0 : row vector initial condition = [X0,Y0,Z0]
% dt : scalar, time step for integration
% iter : scalar, number of iterations for integration
% dX0 : scalar, std dev of the generated Gaussian around X0
% nSimul : scalar, number of simutions with different initial conditions
function compare_X0(X0,dt,iter,dX0,nSimul)

ini = zeros(nSimul,3);	% Randomly generated initial positions around X0
for i=1:3 % X, Y and Z coordinates
	ini(:,i) = normrnd(X0(i),dX0,[nSimul,1]); % Gaussian of mean X0(i) and std dev dX0
end


finalEuler = zeros(nSimul,3); % Final positions of the simulations
finalRK4 = zeros(nSimul,3);
finalode45 = zeros(nSimul,3);
for i=1:nSimul
	[XEuler, XRK4, Xode45] = integration(ini(i,:),dt,iter); % Actual simulation
	finalEuler(i,:) = XEuler(end,:); % Only keep the final position
	finalRK4(i,:) = XRK4(end,:);
	finalode45(i,:) = Xode45(end,:);
end


figure; title('Initial Positions'); % Initial position plot (should be Gaussian)
plot3(ini(:,1),ini(:,2),ini(:,3),'.k');
xlabel('x'); ylabel('y'); zlabel('z');

figure; title('Final Positions')
hold on;
labels = {}; % Just comment out the lines you don't want to plot and the legend should adapt.
	plot3(finalEuler(:,1),finalEuler(:,2),finalEuler(:,3),'.r'); labels= [labels 'Euler'];
	plot3(finalRK4(:,1),finalRK4(:,2),finalRK4(:,3),'.k'); labels= [labels 'RK4'];
	plot3(finalode45(:,1),finalode45(:,2),finalode45(:,3),'.b'); labels= [labels 'ode45'];
hold off;
legend(labels)
xlabel('x'); ylabel('y'); zlabel('z')

end
