% Generates the Lorenz Map
% X : matrix size(n,3) contain [X(t),Y(t),Z(t)] for n values of t
function LorenzMap(XEuler,XRK4,Xode45)

pairsEuler=	makePairs(XEuler);
pairsRK4=	makePairs(XRK4);
pairsode45=	makePairs(Xode45);

figure; title('Lorenz Map')
hold on
labels = {}; % Just comment out the lines you don't want to plot, and the legend should adapt.
	plot(pairsEuler(:,1),pairsEuler(:,2),'.r'); labels= [labels 'Euler'];
	plot(pairsRK4(:,1),pairsRK4(:,2),'.k'); labels= [labels 'RK4'];
	plot(pairsode45(:,1),pairsode45(:,2),'.b'); labels= [labels 'ode45'];
hold off;
legend(labels)
xlabel('z(n)'); ylabel('z(n+1)')

end

