(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      6820,        207]
NotebookOptionsPosition[      6359,        187]
NotebookOutlinePosition[      6696,        202]
CellTagsIndexPosition[      6653,        199]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"\[Psi]", "[", 
   RowBox[{"t_", ",", "x_", ",", "z_"}], "]"}], ":=", " ", 
  RowBox[{
   RowBox[{"X", "[", "t", "]"}], "\[Alpha]1", " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"\[Pi]", " ", "a", " ", 
     RowBox[{"x", "/", "H"}]}], "]"}], " ", 
   RowBox[{"Sin", "[", 
    RowBox[{"\[Pi]", " ", 
     RowBox[{"z", "/", "H"}]}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.735617352461598*^9, 3.73561741212438*^9}, {
  3.736162151127784*^9, 3.736162152345263*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Theta]", "[", 
   RowBox[{"t_", ",", "x_", ",", "z_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{
    RowBox[{"Y", "[", "t", "]"}], "\[Alpha]2", " ", 
    RowBox[{"Cos", "[", 
     RowBox[{"\[Pi]", " ", "a", " ", 
      RowBox[{"x", "/", "H"}]}], "]"}], 
    RowBox[{"Sin", "[", 
     RowBox[{"\[Pi]", " ", 
      RowBox[{"z", "/", "H"}]}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"Z", "[", "t", "]"}], "\[Alpha]3", " ", 
    RowBox[{"Sin", "[", 
     RowBox[{"2", "\[Pi]", " ", 
      RowBox[{"z", "/", "H"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.7356177511473217`*^9, 3.7356177542539682`*^9}, {
  3.735617796412072*^9, 3.7356178631636543`*^9}, {3.736162158858309*^9, 
  3.7361621600109653`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"Lap\[Psi]", "[", 
   RowBox[{"t_", ",", "x_", ",", "z_"}], "]"}], " ", ":=", " ", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Derivative", "[", 
      RowBox[{"0", ",", "2", ",", "0"}], "]"}], "[", "\[Psi]", "]"}], "[", 
    RowBox[{"t", ",", "x", ",", "z"}], "]"}], " ", "+", " ", 
   RowBox[{
    RowBox[{
     RowBox[{"Derivative", "[", 
      RowBox[{"0", ",", "0", ",", "2"}], "]"}], "[", "\[Psi]", "]"}], "[", 
    RowBox[{"t", ",", "x", ",", "z"}], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.736079349328341*^9, 3.736079372630672*^9}, {
  3.7360795851446333`*^9, 3.736079585472845*^9}, {3.736162162346545*^9, 
  3.736162224823189*^9}, {3.736162294610511*^9, 3.736162299942053*^9}, {
  3.7361623322448187`*^9, 3.736162333328397*^9}, {3.736162499717362*^9, 
  3.736162519758308*^9}, {3.736162567664927*^9, 3.7361626256008863`*^9}, {
  3.736833077986496*^9, 3.736833143519938*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"Derivative", "[", 
      RowBox[{"1", ",", "0", ",", "0"}], "]"}], "[", "Lap\[Psi]", "]"}], "[", 
    
    RowBox[{"t", ",", "x", ",", "z"}], "]"}], "-", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Derivative", "[", 
       RowBox[{"0", ",", "0", ",", "1"}], "]"}], "[", "\[Psi]", "]"}], "[", 
     RowBox[{"t", ",", "x", ",", "z"}], "]"}], "  ", 
    RowBox[{
     RowBox[{
      RowBox[{"Derivative", "[", 
       RowBox[{"0", ",", "1", ",", "0"}], "]"}], "[", "Lap\[Psi]", "]"}], "[", 
     RowBox[{"t", ",", "x", ",", "z"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"Derivative", "[", 
       RowBox[{"0", ",", "1", ",", "0"}], "]"}], "[", "\[Psi]", "]"}], "[", 
     RowBox[{"t", ",", "x", ",", "z"}], "]"}], " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Derivative", "[", 
       RowBox[{"0", ",", "0", ",", "1"}], "]"}], "[", "Lap\[Psi]", "]"}], "[", 
     RowBox[{"t", ",", "x", ",", "z"}], "]"}]}], "-", 
   RowBox[{"g", " ", "\[Epsilon]", " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Derivative", "[", 
       RowBox[{"0", ",", "1", ",", "0"}], "]"}], "[", "\[Theta]", "]"}], "[", 
     
     RowBox[{"t", ",", "x", ",", "z"}], "]"}]}], "-", 
   RowBox[{"\[Nu]", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "2", ",", "0"}], "]"}], "[", "Lap\[Psi]", "]"}], 
       "[", 
       RowBox[{"t", ",", "x", ",", "z"}], "]"}], "+", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "0", ",", "2"}], "]"}], "[", "Lap\[Psi]", "]"}], 
       "[", 
       RowBox[{"t", ",", "x", ",", "z"}], "]"}]}], ")"}]}]}], "]"}]], "Input",\

 CellChangeTimes->{{3.736079548855179*^9, 3.736079551088277*^9}, {
   3.7360795922890987`*^9, 3.736079739210442*^9}, 3.736079784766716*^9, 
   3.7361377030079*^9, {3.7361377760887947`*^9, 3.736137778325377*^9}, 
   3.736138016853249*^9, {3.736833249297909*^9, 3.736833377697659*^9}, 
   3.736833408696781*^9, 3.736836093866105*^9}],

Cell[BoxData[
 RowBox[{"-", 
  RowBox[{
   FractionBox["1", 
    SuperscriptBox["H", "4"]], 
   RowBox[{"\[Pi]", " ", 
    RowBox[{"Sin", "[", 
     FractionBox[
      RowBox[{"a", " ", "\[Pi]", " ", "x"}], "H"], "]"}], " ", 
    RowBox[{"Sin", "[", 
     FractionBox[
      RowBox[{"\[Pi]", " ", "z"}], "H"], "]"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"1", "+", 
          SuperscriptBox["a", "2"]}], ")"}], "2"], " ", 
       SuperscriptBox["\[Pi]", "3"], " ", "\[Alpha]1", " ", "\[Nu]", " ", 
       RowBox[{"X", "[", "t", "]"}]}], "+", 
      RowBox[{
       SuperscriptBox["H", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "a"}], " ", "g", " ", "H", " ", "\[Alpha]2", " ", 
          "\[Epsilon]", " ", 
          RowBox[{"Y", "[", "t", "]"}]}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"1", "+", 
            SuperscriptBox["a", "2"]}], ")"}], " ", "\[Pi]", " ", "\[Alpha]1",
           " ", 
          RowBox[{
           SuperscriptBox["X", "\[Prime]",
            MultilineFunction->None], "[", "t", "]"}]}]}], ")"}]}]}], 
     ")"}]}]}]}]], "Output",
 CellChangeTimes->{
  3.736079752566289*^9, 3.736162633832673*^9, {3.7368333798523827`*^9, 
   3.736833385331924*^9}, 3.736833534044158*^9, 3.736836105569672*^9}]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{3.736833421406248*^9}]
},
WindowSize->{682, 701},
WindowMargins->{{Automatic, -9}, {Automatic, -8}},
FrontEndVersion->"10.0 for Linux x86 (64-bit) (December 4, 2014)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 496, 13, 32, "Input"],
Cell[1057, 35, 738, 20, 32, "Input"],
Cell[1798, 57, 927, 20, 55, "Input"],
Cell[CellGroupData[{
Cell[2750, 81, 2126, 58, 187, "Input"],
Cell[4879, 141, 1374, 40, 104, "Output"]
}, Open  ]],
Cell[6268, 184, 87, 1, 55, "Input"]
}
]
*)

(* End of internal cache information *)
