(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[      7013,        257]
NotebookOptionsPosition[      5682,        217]
NotebookOutlinePosition[      6016,        232]
CellTagsIndexPosition[      5973,        229]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"a_", ",", "x_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{"a", "*", "x"}], "-", 
    RowBox[{"x", "^", "3"}]}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"f2", "[", 
    RowBox[{"a_", ",", "x_"}], "]"}], ":=", 
   RowBox[{"f", "[", 
    RowBox[{"a", ",", 
     RowBox[{"f", "[", 
      RowBox[{"a", ",", "x"}], "]"}]}], "]"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.8606499862448*^9, 
  3.860650035568421*^9}},ExpressionUUID->"c19980f1-6b39-41db-918b-\
d5b74b8f3652"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"f2", "[", 
  RowBox[{"a", ",", "x"}], "]"}]], "Input",
 CellChangeTimes->{{3.860650038721203*^9, 
  3.860650040824066*^9}},ExpressionUUID->"ff3d370f-2495-4601-82d2-\
48430183940f"],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"a", " ", "x"}], "-", 
     SuperscriptBox["x", "3"]}], ")"}]}], "-", 
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"a", " ", "x"}], "-", 
     SuperscriptBox["x", "3"]}], ")"}], "3"]}]], "Output",
 CellChangeTimes->{
  3.8606500416170607`*^9},ExpressionUUID->"d0dac430-ff56-4e36-b713-\
35614c87035d"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"f2", "[", 
     RowBox[{"a", ",", "x"}], "]"}], "\[Equal]", "x"}], ",", "x"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.8606500444776573`*^9, 
  3.8606500528801107`*^9}},ExpressionUUID->"ad50a8b1-2a43-4447-becc-\
5921aae00c65"],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", "0"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{
        RowBox[{"-", "1"}], "+", "a"}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     SqrtBox[
      RowBox[{
       RowBox[{"-", "1"}], "+", "a"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      SqrtBox[
       RowBox[{"1", "+", "a"}]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     SqrtBox[
      RowBox[{"1", "+", "a"}]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       SqrtBox[
        RowBox[{"a", "-", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "4"}], "+", 
           SuperscriptBox["a", "2"]}]]}]], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox[
      SqrtBox[
       RowBox[{"a", "-", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          SuperscriptBox["a", "2"]}]]}]], 
      SqrtBox["2"]]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     RowBox[{"-", 
      FractionBox[
       SqrtBox[
        RowBox[{"a", "+", 
         SqrtBox[
          RowBox[{
           RowBox[{"-", "4"}], "+", 
           SuperscriptBox["a", "2"]}]]}]], 
       SqrtBox["2"]]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", "\[Rule]", 
     FractionBox[
      SqrtBox[
       RowBox[{"a", "+", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          SuperscriptBox["a", "2"]}]]}]], 
      SqrtBox["2"]]}], "}"}]}], "}"}]], "Output",
 CellChangeTimes->{
  3.860650053305765*^9},ExpressionUUID->"991ba3de-5dd7-499a-9bec-\
244c46e1bd7c"]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"f2Der", "[", 
    RowBox[{"a_", ",", "x_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"Derivative", "[", 
      RowBox[{"0", ",", "1"}], "]"}], "[", "f2", "]"}], "[", 
    RowBox[{"a", ",", "x"}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.860651791652233*^9, 
  3.8606518375386887`*^9}},ExpressionUUID->"6406a02f-16e9-41fa-82c5-\
5a815af4b910"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f2Der", "[", 
   RowBox[{"a", ",", 
    RowBox[{"-", 
     RowBox[{"Sqrt", "[", 
      RowBox[{"a", "+", "1"}], "]"}]}]}], "]"}], "//", 
  "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.860651839005232*^9, 
  3.860651872914534*^9}},ExpressionUUID->"6af8b74e-c94b-456d-adea-\
415e6d4cb13b"],

Cell[BoxData[
 SuperscriptBox[
  RowBox[{"(", 
   RowBox[{"3", "+", 
    RowBox[{"2", " ", "a"}]}], ")"}], "2"]], "Output",
 CellChangeTimes->{{3.860651850764051*^9, 
  3.860651873698711*^9}},ExpressionUUID->"565688a2-6463-4566-bcbf-\
158c4902df29"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"f2Der", "[", 
   RowBox[{"a", ",", 
    RowBox[{"-", 
     FractionBox[
      SqrtBox[
       RowBox[{"a", "+", 
        SqrtBox[
         RowBox[{
          RowBox[{"-", "4"}], "+", 
          SuperscriptBox["a", "2"]}]]}]], 
      SqrtBox["2"]]}]}], "]"}], "//", "FullSimplify"}]], "Input",
 CellChangeTimes->{{3.8606519102255096`*^9, 
  3.860651936962069*^9}},ExpressionUUID->"b9d3a9aa-8a5a-42c0-9d5e-\
42f67e5e2d8e"],

Cell[BoxData[
 RowBox[{"9", "-", 
  RowBox[{"2", " ", 
   SuperscriptBox["a", "2"]}]}]], "Output",
 CellChangeTimes->{{3.8606519303881083`*^9, 
  3.860651937375984*^9}},ExpressionUUID->"d4d48bf9-cf3b-447f-bf64-\
5ca9e2921699"]
}, Open  ]]
},
WindowSize->{808, 911},
WindowMargins->{{0, Automatic}, {Automatic, 29}},
FrontEndVersion->"11.1 for Linux x86 (64-bit) (April 18, 2017)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 562, 18, 59, "Input", "ExpressionUUID" -> \
"c19980f1-6b39-41db-918b-d5b74b8f3652"],
Cell[CellGroupData[{
Cell[1145, 42, 204, 5, 35, "Input", "ExpressionUUID" -> \
"ff3d370f-2495-4601-82d2-48430183940f"],
Cell[1352, 49, 405, 14, 37, "Output", "ExpressionUUID" -> \
"d0dac430-ff56-4e36-b713-35614c87035d"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1794, 68, 302, 9, 35, "Input", "ExpressionUUID" -> \
"ad50a8b1-2a43-4447-becc-5921aae00c65"],
Cell[2099, 79, 1819, 69, 201, "Output", "ExpressionUUID" -> \
"991ba3de-5dd7-499a-9bec-244c46e1bd7c"]
}, Open  ]],
Cell[3933, 151, 408, 12, 35, "Input", "ExpressionUUID" -> \
"6406a02f-16e9-41fa-82c5-5a815af4b910"],
Cell[CellGroupData[{
Cell[4366, 167, 327, 10, 35, "Input", "ExpressionUUID" -> \
"6af8b74e-c94b-456d-adea-415e6d4cb13b"],
Cell[4696, 179, 249, 7, 33, "Output", "ExpressionUUID" -> \
"565688a2-6463-4566-bcbf-158c4902df29"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4982, 191, 455, 15, 84, "Input", "ExpressionUUID" -> \
"b9d3a9aa-8a5a-42c0-9d5e-42f67e5e2d8e"],
Cell[5440, 208, 226, 6, 33, "Output", "ExpressionUUID" -> \
"d4d48bf9-cf3b-447f-bf64-5ca9e2921699"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

