% For a given 'a_' it returns the sign of the relative position between xnear and xmax
% a_ (scalar): real parameter for the difference equation
% rel_pos (scalar -1, 0 or +1): sign of relative position between xnear and xmax
% 		+1 if xnear > xmax
% 		 0 if xnear = xmax (will almost never happen)
% 		-1 if xnear < xmax
function rel_pos = rel_pos_xnear(a_)

x0=0.5; % Initial condition of simulation
N=1000; % Length of simulation
Nlast=2^7; % Only keep the last Nlast points. (2^r means it can identify up to a 2^r-cycle)

global a; a = a_; % Gives value of a_ to diffEq through global variable
X = compute_map(x0,N); % Simulation
X = X(end-Nlast+1:end); % Only keep the converged points, on the limit cycle


xmax = sqrt(a/3); % f_a(xmax) is the local maximum
[value, index] = min( abs(X-xmax ) ); % Finding the index of xnear
xnear = X(index); % Point of the limit cycle nearest to xmax

rel_pos = sign( xnear-xmax ); % Sign of relative position

end


